/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.TransactionContext;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.cloud.gcp.data.spanner.core.SpannerMutationFactory;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.SpannerReadOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerConverter;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;

class ReadWriteTransactionSpannerTemplate
extends SpannerTemplate {
    private TransactionContext transactionContext;

    ReadWriteTransactionSpannerTemplate(DatabaseClient databaseClient, SpannerMappingContext mappingContext, SpannerConverter spannerConverter, SpannerMutationFactory spannerMutationFactory, TransactionContext transactionContext) {
        super(databaseClient, mappingContext, spannerConverter, spannerMutationFactory);
        this.transactionContext = transactionContext;
    }

    @Override
    protected <T, U> void applyMutationTwoArgs(BiFunction<T, U, Mutation> function, T arg1, U arg2) {
        this.transactionContext.buffer(function.apply(arg1, arg2));
    }

    @Override
    protected ReadContext getReadContext() {
        return this.transactionContext;
    }

    @Override
    protected ReadContext getReadContext(Timestamp timestamp) {
        throw new SpannerDataException("Getting stale snapshot read contexts is not supported in read-write transaction templates.");
    }

    @Override
    public <T> T performReadWriteTransaction(Function<SpannerOperations, T> operations) {
        throw new SpannerDataException("A read-write transaction is already under execution. Opening sub-transactions is not supported!");
    }

    @Override
    public <T> T performReadOnlyTransaction(Function<SpannerOperations, T> operations, SpannerReadOptions readOptions) {
        throw new SpannerDataException("A read-write transaction is already under execution. Opening sub-transactions is not supported!");
    }
}

