/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore;

import org.reactivestreams.Publisher;
import org.springframework.cloud.gcp.data.firestore.FirestoreReactiveRepository;
import org.springframework.cloud.gcp.data.firestore.FirestoreTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleFirestoreReactiveRepository<T>
implements FirestoreReactiveRepository<T> {
    private FirestoreTemplate firestoreTemplate;
    private Class type;

    public SimpleFirestoreReactiveRepository(FirestoreTemplate firestoreTemplate, Class type) {
        this.firestoreTemplate = firestoreTemplate;
        this.type = type;
    }

    public <S extends T> Mono<S> save(S entity) {
        return this.firestoreTemplate.save(entity);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        return this.firestoreTemplate.saveAll(Flux.fromIterable(entities));
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        return this.firestoreTemplate.saveAll(entityStream);
    }

    public Mono<T> findById(String id) {
        return this.findById((Publisher<String>)Mono.just((Object)id));
    }

    public Mono<T> findById(Publisher<String> idPublisher) {
        return this.firestoreTemplate.findById(idPublisher, this.type);
    }

    public Mono<Boolean> existsById(String id) {
        return this.existsById((Publisher)Mono.just((Object)id));
    }

    public Mono<Boolean> existsById(Publisher idPublisher) {
        return this.firestoreTemplate.existsById((Publisher<String>)idPublisher, this.type);
    }

    public Flux<T> findAll() {
        return this.firestoreTemplate.findAll(this.type);
    }

    public Flux<T> findAllById(Iterable<String> iterable) {
        return this.findAllById((Publisher<String>)Flux.fromIterable(iterable));
    }

    public Flux<T> findAllById(Publisher<String> idStream) {
        return this.firestoreTemplate.findAllById(idStream, this.type);
    }

    public Mono<Long> count() {
        return this.firestoreTemplate.count(this.type);
    }

    public Mono<Void> deleteById(String id) {
        return this.deleteById((Publisher)Mono.just((Object)id));
    }

    public Mono<Void> deleteById(Publisher idPublisher) {
        return this.firestoreTemplate.deleteById((Publisher<String>)idPublisher, this.type);
    }

    public Mono<Void> delete(Object entity) {
        return this.firestoreTemplate.delete(Mono.just((Object)entity));
    }

    public Mono<Void> deleteAll(Iterable entities) {
        return this.firestoreTemplate.delete(Flux.fromIterable((Iterable)entities));
    }

    public Mono<Void> deleteAll(Publisher entityStream) {
        return this.firestoreTemplate.delete(entityStream);
    }

    public Mono<Void> deleteAll() {
        return this.firestoreTemplate.deleteAll(this.type);
    }
}

