/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.repository.query;

import com.google.firestore.v1.StructuredQuery;
import com.google.protobuf.Int32Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.cloud.gcp.core.util.MapBuilder;
import org.springframework.cloud.gcp.data.firestore.FirestoreDataException;
import org.springframework.cloud.gcp.data.firestore.FirestoreReactiveOperations;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreClassMapper;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreMappingContext;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentEntity;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentProperty;
import org.springframework.cloud.gcp.data.firestore.repository.query.FirestoreQueryMethod;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeFirestoreQuery
implements RepositoryQuery {
    private final PartTree tree;
    private final FirestoreQueryMethod queryMethod;
    private final FirestoreReactiveOperations reactiveOperations;
    private final FirestorePersistentEntity<?> persistentEntity;
    private final FirestoreClassMapper classMapper;
    private final FirestoreMappingContext mappingContext;
    private static final Map<Part.Type, OperatorSelector> PART_TO_FILTER_OP = new MapBuilder().put((Object)Part.Type.SIMPLE_PROPERTY, (Object)new OperatorSelector(StructuredQuery.FieldFilter.Operator.EQUAL)).put((Object)Part.Type.GREATER_THAN_EQUAL, (Object)new OperatorSelector(StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL)).put((Object)Part.Type.GREATER_THAN, (Object)new OperatorSelector(StructuredQuery.FieldFilter.Operator.GREATER_THAN)).put((Object)Part.Type.LESS_THAN_EQUAL, (Object)new OperatorSelector(StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL)).put((Object)Part.Type.LESS_THAN, (Object)new OperatorSelector(StructuredQuery.FieldFilter.Operator.LESS_THAN)).put((Object)Part.Type.IN, (Object)new OperatorSelector(StructuredQuery.FieldFilter.Operator.IN)).put((Object)Part.Type.CONTAINING, (Object)new OperatorSelector(StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS, StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY)).build();

    public PartTreeFirestoreQuery(FirestoreQueryMethod queryMethod, FirestoreReactiveOperations reactiveOperations, FirestoreMappingContext mappingContext, FirestoreClassMapper classMapper) {
        this.queryMethod = queryMethod;
        this.reactiveOperations = reactiveOperations;
        ReturnedType returnedType = queryMethod.getResultProcessor().getReturnedType();
        this.tree = new PartTree(queryMethod.getName(), returnedType.getDomainType());
        this.persistentEntity = (FirestorePersistentEntity)mappingContext.getPersistentEntity(returnedType.getDomainType());
        this.mappingContext = mappingContext;
        this.classMapper = classMapper;
        this.validate();
    }

    private void validate() {
        List parts = this.tree.get().collect(Collectors.toList());
        if (parts.size() > 1 && parts.get(0) instanceof PartTree.OrPart) {
            throw new FirestoreDataException("Cloud Firestore doesn't support 'OR' (method name: " + this.getQueryMethod().getName() + ")");
        }
        List unsupportedParts = this.tree.getParts().stream().filter(part -> !this.isSupportedPart(part.getType())).map(part -> part.getType().toString()).collect(Collectors.toList());
        if (!unsupportedParts.isEmpty()) {
            throw new FirestoreDataException("Unsupported predicate keywords: " + unsupportedParts + " in " + this.getQueryMethod().getName());
        }
    }

    private boolean isSupportedPart(Part.Type partType) {
        return PART_TO_FILTER_OP.containsKey(partType) || partType == Part.Type.IS_NULL;
    }

    public Object execute(Object[] parameters) {
        StructuredQuery.Builder builder = this.createBuilderWithFilter(parameters);
        if (!this.getQueryMethod().getParameters().isEmpty()) {
            Sort sort;
            ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
            Pageable pageable = paramAccessor.getPageable();
            if (pageable != null && pageable.isPaged()) {
                builder.setOffset((int)Math.min(Integer.MAX_VALUE, pageable.getOffset()));
                builder.setLimit(Int32Value.newBuilder().setValue(pageable.getPageSize()));
            }
            if ((sort = paramAccessor.getSort()) != null) {
                builder.addAllOrderBy(this.createFirestoreSortOrders(sort));
            }
        }
        if (this.tree.isCountProjection()) {
            return this.reactiveOperations.count(this.persistentEntity.getType(), builder);
        }
        return this.reactiveOperations.execute(builder, this.persistentEntity.getType());
    }

    private List<StructuredQuery.Order> createFirestoreSortOrders(Sort sort) {
        ArrayList<StructuredQuery.Order> sortOrders = new ArrayList<StructuredQuery.Order>();
        for (Sort.Order order : sort) {
            if (order.isIgnoreCase()) {
                throw new IllegalArgumentException("Datastore does not support ignore case sort orders.");
            }
            String fieldName = ((FirestorePersistentProperty)this.persistentEntity.getPersistentProperty(order.getProperty())).getFieldName();
            StructuredQuery.Direction dir = order.getDirection() == Sort.Direction.DESC ? StructuredQuery.Direction.DESCENDING : StructuredQuery.Direction.ASCENDING;
            StructuredQuery.FieldReference ref = StructuredQuery.FieldReference.newBuilder().setFieldPath(fieldName).build();
            StructuredQuery.Order firestoreOrder = StructuredQuery.Order.newBuilder().setField(ref).setDirection(dir).build();
            sortOrders.add(firestoreOrder);
        }
        return sortOrders;
    }

    private StructuredQuery.Builder createBuilderWithFilter(Object[] parameters) {
        StructuredQuery.Builder builder = StructuredQuery.newBuilder();
        Iterator<Object> it = Arrays.asList(parameters).iterator();
        StructuredQuery.CompositeFilter.Builder compositeFilter = StructuredQuery.CompositeFilter.newBuilder();
        compositeFilter.setOp(StructuredQuery.CompositeFilter.Operator.AND);
        this.tree.getParts().forEach(part -> {
            StructuredQuery.FieldReference fieldReference = StructuredQuery.FieldReference.newBuilder().setFieldPath(this.buildName((Part)part)).build();
            StructuredQuery.Filter.Builder filter = StructuredQuery.Filter.newBuilder();
            if (part.getType() == Part.Type.IS_NULL) {
                filter.getUnaryFilterBuilder().setField(fieldReference).setOp(StructuredQuery.UnaryFilter.Operator.IS_NULL);
            } else {
                if (!it.hasNext()) {
                    throw new FirestoreDataException("Too few parameters are provided for query method: " + this.getQueryMethod().getName());
                }
                Object value = it.next();
                filter.getFieldFilterBuilder().setField(fieldReference).setOp(this.getOperator((Part)part, value)).setValue(this.classMapper.toFirestoreValue(value));
            }
            compositeFilter.addFilters(filter.build());
        });
        builder.setWhere(StructuredQuery.Filter.newBuilder().setCompositeFilter(compositeFilter.build()));
        return builder;
    }

    private String buildName(Part part) {
        Iterable iterable = () -> part.getProperty().iterator();
        return StreamSupport.stream(iterable.spliterator(), false).map(propertyPath -> {
            FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(propertyPath.getOwningType());
            return ((FirestorePersistentProperty)persistentEntity.getPersistentProperty(propertyPath.getSegment())).getFieldName();
        }).collect(Collectors.joining("."));
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private StructuredQuery.FieldFilter.Operator getOperator(Part part, Object value) {
        OperatorSelector operatorSelector = PART_TO_FILTER_OP.get(part.getType());
        return operatorSelector.getOperator(value);
    }

    static class OperatorSelector {
        StructuredQuery.FieldFilter.Operator operatorForSingleType;
        StructuredQuery.FieldFilter.Operator operatorForIterableType;

        OperatorSelector(StructuredQuery.FieldFilter.Operator operatorForSingleType, StructuredQuery.FieldFilter.Operator operatorForIterableType) {
            this.operatorForSingleType = operatorForSingleType;
            this.operatorForIterableType = operatorForIterableType;
        }

        OperatorSelector(StructuredQuery.FieldFilter.Operator commonOperator) {
            this.operatorForSingleType = commonOperator;
            this.operatorForIterableType = commonOperator;
        }

        StructuredQuery.FieldFilter.Operator getOperator(Object val) {
            return val instanceof Iterable ? this.operatorForIterableType : this.operatorForSingleType;
        }
    }
}

