/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.cloud.gcp.data.firestore.Document;
import org.springframework.cloud.gcp.data.firestore.FirestoreReactiveRepository;
import org.springframework.cloud.gcp.data.firestore.repository.support.FirestoreRepositoryFactoryBean;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.w3c.dom.Element;

public class FirestoreRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    protected String getModulePrefix() {
        return "firestore-reactive";
    }

    public String getRepositoryFactoryBeanClassName() {
        return FirestoreRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("firestoreTemplate", attributes.getString("firestoreTemplateRef"));
        builder.addPropertyReference("firestoreMappingContext", attributes.getString("firestoreMappingContextRef"));
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Document.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(FirestoreReactiveRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)"firestore-template-ref", (String)"firestoreTemplate");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)"firestore-mapping-context-ref", (String)"firestoreMappingContext");
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata repositoryMetadata) {
        return repositoryMetadata.isReactiveRepository();
    }
}

