/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.repository.support;

import java.lang.reflect.Method;
import org.springframework.cloud.gcp.data.firestore.FirestoreTemplate;
import org.springframework.cloud.gcp.data.firestore.repository.query.FirestoreQueryMethod;
import org.springframework.cloud.gcp.data.firestore.repository.query.PartTreeFirestoreQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class FirestoreQueryLookupStrategy
implements QueryLookupStrategy {
    private final FirestoreTemplate firestoreTemplate;

    public FirestoreQueryLookupStrategy(FirestoreTemplate firestoreTemplate) {
        this.firestoreTemplate = firestoreTemplate;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        return new PartTreeFirestoreQuery(new FirestoreQueryMethod(method, repositoryMetadata, projectionFactory), this.firestoreTemplate, this.firestoreTemplate.getMappingContext());
    }
}

