/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.mapping;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.Internal;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import java.util.Map;
import org.springframework.cloud.gcp.core.util.MapBuilder;

public final class PublicClassMapper {
    private static final Internal INTERNAL = new Internal(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("dummy-project-id")).build(), null);
    private static final String VALUE_FIELD_NAME = "value";
    private static final String NOT_USED_PATH = "/not/used/path";

    private PublicClassMapper() {
    }

    public static <T> Value convertToFirestoreValue(T entity) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromMap(NOT_USED_PATH, new MapBuilder().put((Object)VALUE_FIELD_NAME, entity).build());
        return (Value)INTERNAL.protoFromSnapshot(documentSnapshot).get(VALUE_FIELD_NAME);
    }

    public static <T> Map<String, Value> convertToFirestoreTypes(T entity) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromObject(NOT_USED_PATH, entity);
        return INTERNAL.protoFromSnapshot(documentSnapshot);
    }

    public static <T> T convertToCustomClass(Document document, Class<T> clazz) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromProto(Timestamp.now(), document);
        return (T)documentSnapshot.toObject(clazz);
    }
}

