/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.support;

import org.springframework.beans.BeansException;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.repository.DatastoreRepository;
import org.springframework.cloud.gcp.data.datastore.repository.support.DatastoreRepositoryFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class DatastoreRepositoryFactoryBean<S, ID>
extends RepositoryFactoryBeanSupport<DatastoreRepository<S, ID>, S, ID>
implements ApplicationContextAware {
    private DatastoreMappingContext datastoreMappingContext;
    private DatastoreTemplate datastoreTemplate;
    private ApplicationContext applicationContext;

    DatastoreRepositoryFactoryBean(Class<DatastoreRepository<S, ID>> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setDatastoreTemplate(DatastoreTemplate datastoreTemplate) {
        this.datastoreTemplate = datastoreTemplate;
    }

    public void setDatastoreMappingContext(DatastoreMappingContext mappingContext) {
        super.setMappingContext((MappingContext)mappingContext);
        this.datastoreMappingContext = mappingContext;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        DatastoreRepositoryFactory datastoreRepositoryFactory = new DatastoreRepositoryFactory(this.datastoreMappingContext, this.datastoreTemplate);
        datastoreRepositoryFactory.setApplicationContext(this.applicationContext);
        return datastoreRepositoryFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

