/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.cloud.gcp.data.datastore.repository.query.Query;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;

public class DatastoreQueryMethod
extends QueryMethod {
    private final Method method;
    private Boolean isNullable = null;

    DatastoreQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
    }

    boolean hasAnnotatedQuery() {
        return this.getQueryAnnotation() != null;
    }

    Class getCollectionReturnType() {
        return this.isCollectionQuery() ? this.method.getReturnType() : null;
    }

    boolean isExistsQuery() {
        Query annotation = this.getQueryAnnotation();
        return annotation != null && annotation.exists();
    }

    boolean isCountQuery() {
        Query annotation = this.getQueryAnnotation();
        return annotation != null && annotation.count();
    }

    @Nullable
    Query getQueryAnnotation() {
        return (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
    }

    boolean isNullable() {
        if (this.isNullable == null) {
            Optional<Annotation> nullable = Arrays.stream(this.method.getAnnotations()).filter(annotation -> annotation instanceof Nullable).findFirst();
            this.isNullable = nullable.isPresent();
        }
        return this.isNullable;
    }

    boolean isOptionalReturnType() {
        return this.method.getReturnType().isAssignableFrom(Optional.class);
    }
}

