/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.cloud.gcp.data.datastore.core.mapping.Entity;
import org.springframework.cloud.gcp.data.datastore.repository.DatastoreRepository;
import org.springframework.cloud.gcp.data.datastore.repository.support.DatastoreRepositoryFactoryBean;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.w3c.dom.Element;

public class DatastoreRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    protected String getModulePrefix() {
        return "datastore";
    }

    public String getRepositoryFactoryBeanClassName() {
        return DatastoreRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("datastoreTemplate", attributes.getString("datastoreTemplateRef"));
        builder.addPropertyReference("datastoreMappingContext", attributes.getString("datastoreMappingContextRef"));
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Entity.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(DatastoreRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)"datastore-template-ref", (String)"datastoreTemplate");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)"datastore-mapping-context-ref", (String)"datastoreMappingContext");
    }
}

