/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.query;

import java.lang.reflect.Method;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreOperations;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastoreQueryMethod;
import org.springframework.cloud.gcp.data.datastore.repository.query.GqlDatastoreQuery;
import org.springframework.cloud.gcp.data.datastore.repository.query.PartTreeDatastoreQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class DatastoreQueryLookupStrategy
implements QueryLookupStrategy {
    private final DatastoreOperations datastoreOperations;
    private final DatastoreMappingContext datastoreMappingContext;
    private QueryMethodEvaluationContextProvider evaluationContextProvider;

    public DatastoreQueryLookupStrategy(DatastoreMappingContext datastoreMappingContext, DatastoreOperations datastoreOperations, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)((Object)datastoreMappingContext), (String)"A non-null DatastoreMappingContext is required.");
        Assert.notNull((Object)datastoreOperations, (String)"A non-null DatastoreOperations is required.");
        Assert.notNull((Object)evaluationContextProvider, (String)"A non-null EvaluationContextProvider is required.");
        this.datastoreMappingContext = datastoreMappingContext;
        this.evaluationContextProvider = evaluationContextProvider;
        this.datastoreOperations = datastoreOperations;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        DatastoreQueryMethod queryMethod = this.createQueryMethod(method, metadata, projectionFactory);
        Class<?> entityType = this.getEntityType(queryMethod);
        if (queryMethod.hasAnnotatedQuery()) {
            String sql = queryMethod.getQueryAnnotation().value();
            return this.createGqlDatastoreQuery(entityType, queryMethod, sql);
        }
        if (namedQueries.hasQuery(queryMethod.getNamedQueryName())) {
            String sql = namedQueries.getQuery(queryMethod.getNamedQueryName());
            return this.createGqlDatastoreQuery(entityType, queryMethod, sql);
        }
        return new PartTreeDatastoreQuery(queryMethod, this.datastoreOperations, this.datastoreMappingContext, entityType, projectionFactory);
    }

    <T> GqlDatastoreQuery<T> createGqlDatastoreQuery(Class<T> entityType, DatastoreQueryMethod queryMethod, String gql) {
        return new GqlDatastoreQuery<T>(entityType, queryMethod, this.datastoreOperations, gql, this.evaluationContextProvider, this.datastoreMappingContext);
    }

    Class<?> getEntityType(QueryMethod queryMethod) {
        return queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    DatastoreQueryMethod createQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        return new DatastoreQueryMethod(method, metadata, factory);
    }
}

