/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core.convert;

import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreNativeTypes;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.JodaTimeConverters;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.convert.ThreeTenBackPortConverters;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class DatastoreCustomConversions
extends CustomConversions {
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;
    private static final List<Converter<?, ?>> STORE_CONVERTERS;

    public DatastoreCustomConversions() {
        this(Collections.emptyList());
    }

    public DatastoreCustomConversions(List<?> converters) {
        super(STORE_CONVERSIONS, converters);
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(JodaTimeConverters.getConvertersToRegister());
        converters.addAll(Jsr310Converters.getConvertersToRegister());
        converters.addAll(ThreeTenBackPortConverters.getConvertersToRegister());
        converters.add(new Converter<BaseKey, Long>(){

            public Long convert(BaseKey key) {
                Long id = null;
                if (key instanceof Key && (id = ((Key)key).getId()) == null) {
                    throw new DatastoreDataException("The given key doesn't have a numeric ID but a conversion to Long was attempted: " + key);
                }
                return id;
            }
        });
        converters.add(new Converter<BaseKey, String>(){

            public String convert(BaseKey key) {
                String name = null;
                if (key instanceof Key && (name = ((Key)key).getName()) == null) {
                    throw new DatastoreDataException("The given key doesn't have a String name value but a conversion to String was attempted: " + key);
                }
                return name;
            }
        });
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)DatastoreNativeTypes.HOLDER, STORE_CONVERTERS);
    }
}

