/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreReaderWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.PathElement;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Value;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreOperations;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreQueryOptions;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreResultsCollection;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreResultsIterable;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTransactionManager;
import org.springframework.cloud.gcp.data.datastore.core.LazyUtil;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreEntityConverter;
import org.springframework.cloud.gcp.data.datastore.core.convert.ObjectToKeyFactory;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.core.mapping.event.AfterDeleteEvent;
import org.springframework.cloud.gcp.data.datastore.core.mapping.event.AfterFindByKeyEvent;
import org.springframework.cloud.gcp.data.datastore.core.mapping.event.AfterQueryEvent;
import org.springframework.cloud.gcp.data.datastore.core.mapping.event.AfterSaveEvent;
import org.springframework.cloud.gcp.data.datastore.core.mapping.event.BeforeDeleteEvent;
import org.springframework.cloud.gcp.data.datastore.core.mapping.event.BeforeSaveEvent;
import org.springframework.cloud.gcp.data.datastore.core.util.KeyUtil;
import org.springframework.cloud.gcp.data.datastore.core.util.SliceUtil;
import org.springframework.cloud.gcp.data.datastore.core.util.ValueUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.TypeUtils;

public class DatastoreTemplate
implements DatastoreOperations,
ApplicationEventPublisherAware {
    private int maxWriteSize = 500;
    private final Supplier<? extends DatastoreReaderWriter> datastore;
    private final DatastoreEntityConverter datastoreEntityConverter;
    private final DatastoreMappingContext datastoreMappingContext;
    private final ObjectToKeyFactory objectToKeyFactory;
    @Nullable
    private ApplicationEventPublisher eventPublisher;

    public DatastoreTemplate(Supplier<? extends DatastoreReaderWriter> datastore, DatastoreEntityConverter datastoreEntityConverter, DatastoreMappingContext datastoreMappingContext, ObjectToKeyFactory objectToKeyFactory) {
        Assert.notNull(datastore, (String)"A non-null Datastore service object is required.");
        Assert.notNull((Object)datastoreEntityConverter, (String)"A non-null DatastoreEntityConverter is required.");
        Assert.notNull((Object)((Object)datastoreMappingContext), (String)"A non-null DatastoreMappingContext is required.");
        Assert.notNull((Object)objectToKeyFactory, (String)"A non-null Object to Key factory is required.");
        this.datastore = datastore;
        this.datastoreEntityConverter = datastoreEntityConverter;
        this.datastoreMappingContext = datastoreMappingContext;
        this.objectToKeyFactory = objectToKeyFactory;
    }

    public DatastoreEntityConverter getDatastoreEntityConverter() {
        return this.datastoreEntityConverter;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Iterator<T> results = this.performFindByKey(Collections.singleton(id), entityClass).iterator();
        return results.hasNext() ? (T)results.next() : null;
    }

    @Override
    public <T> T save(T instance, Key ... ancestors) {
        List<T> instances = Collections.singletonList(instance);
        this.saveEntities(instances, ancestors);
        return instance;
    }

    @Override
    public <T> Iterable<T> saveAll(Iterable<T> entities, Key ... ancestors) {
        ArrayList instances;
        if (entities instanceof List) {
            instances = (ArrayList)entities;
        } else {
            instances = new ArrayList();
            entities.forEach(instances::add);
        }
        this.saveEntities(instances, ancestors);
        return entities;
    }

    private <T> List<Entity> getEntitiesForSave(Iterable<T> entities, Set<Key> persisted, Key ... ancestors) {
        LinkedList<Entity> entitiesForSave = new LinkedList<Entity>();
        for (T entity : entities) {
            Key key = this.getKey(entity, true, ancestors);
            if (persisted.contains(key)) continue;
            persisted.add(key);
            entitiesForSave.addAll(this.convertToEntityForSave(entity, persisted, ancestors));
        }
        return entitiesForSave;
    }

    private <T> void saveEntities(List<T> instances, Key[] ancestors) {
        if (!instances.isEmpty()) {
            this.maybeEmitEvent(new BeforeSaveEvent(instances));
            List<Entity> entities = this.getEntitiesForSave(instances, new HashSet<Key>(), ancestors);
            SliceUtil.sliceAndExecute(entities.toArray(new Entity[0]), this.maxWriteSize, arg_0 -> ((DatastoreReaderWriter)this.getDatastoreReadWriter()).put(arg_0));
            this.maybeEmitEvent(new AfterSaveEvent(entities, instances));
        }
    }

    @Override
    public <T> void deleteById(Object id, Class<T> entityClass) {
        this.performDelete(new Key[]{this.getKeyFromId(id, entityClass)}, Collections.singletonList(id), null, entityClass);
    }

    @Override
    public <T> void deleteAllById(Iterable<?> ids, Class<T> entityClass) {
        this.performDelete(this.getKeysFromIds(ids, entityClass).toArray(new Key[0]), ids, null, entityClass);
    }

    @Override
    public <T> void delete(T entity) {
        this.performDelete(new Key[]{this.getKey(entity, false, new Key[0])}, null, Collections.singletonList(entity), entity.getClass());
    }

    @Override
    public <T> void deleteAll(Iterable<T> entities) {
        this.performDelete((Key[])StreamSupport.stream(entities.spliterator(), false).map(x -> this.getKey(x, false, new Key[0])).toArray(Key[]::new), null, entities, null);
    }

    @Override
    public long deleteAll(Class<?> entityClass) {
        Key[] keysToDelete = this.findAllKeys(entityClass);
        this.performDelete(keysToDelete, null, null, entityClass);
        return keysToDelete.length;
    }

    private void performDelete(Key[] keys, Iterable ids, Iterable entities, Class entityClass) {
        this.maybeEmitEvent(new BeforeDeleteEvent(keys, entityClass, ids, entities));
        SliceUtil.sliceAndExecute(keys, this.maxWriteSize, arg_0 -> ((DatastoreReaderWriter)this.getDatastoreReadWriter()).delete(arg_0));
        this.maybeEmitEvent(new AfterDeleteEvent(keys, entityClass, ids, entities));
    }

    @Override
    public long count(Class<?> entityClass) {
        return this.findAllKeys(entityClass).length;
    }

    public <T> Collection<T> findAllById(Iterable<?> ids, Class<T> entityClass) {
        return this.performFindByKey(ids, entityClass);
    }

    private <T> Collection<T> performFindByKey(Iterable<?> ids, Class<T> entityClass) {
        Set<Key> keys = this.getKeysFromIds(ids, entityClass);
        List<T> results = this.findAllById(keys, entityClass, new ReadContext());
        this.maybeEmitEvent(new AfterFindByKeyEvent(results, keys));
        return results;
    }

    private <T> List<T> findAllById(Set<Key> keys, Class<T> entityClass, ReadContext context) {
        List<Key> missingKeys = keys.stream().filter(context::notCached).collect(Collectors.toList());
        if (!missingKeys.isEmpty()) {
            List entities = this.getDatastoreReadWriter().fetch(missingKeys.toArray(new Key[0]));
            Assert.isTrue((missingKeys.size() == entities.size() ? 1 : 0) != 0, (String)"Fetched incorrect number of entities");
            for (int i = 0; i < missingKeys.size(); ++i) {
                BaseKey key = (BaseKey)missingKeys.get(i);
                context.putReadEntity(key, (BaseEntity)entities.get(i));
            }
        }
        return this.convertEntitiesForRead(keys, entityClass, context);
    }

    public <T> DatastoreResultsIterable<T> query(Query<? extends BaseEntity> query, Class<T> entityClass) {
        QueryResults results = this.getDatastoreReadWriter().run(query);
        List<T> convertedResults = this.convertEntitiesForRead((Iterator<? extends BaseEntity>)results, entityClass);
        this.maybeEmitEvent(new AfterQueryEvent(convertedResults, query));
        return results != null ? new DatastoreResultsIterable<T>(convertedResults, results.getCursorAfter()) : null;
    }

    public <T> DatastoreResultsIterable<?> queryKeysOrEntities(Query query, Class<T> entityClass) {
        QueryResults results = this.getDatastoreReadWriter().run(query);
        DatastoreResultsIterable resultsIterable = results.getResultClass() == Key.class ? new DatastoreResultsIterable(results, results.getCursorAfter()) : new DatastoreResultsIterable<T>(this.convertEntitiesForRead((Iterator<? extends BaseEntity>)results, entityClass), results.getCursorAfter());
        this.maybeEmitEvent(new AfterQueryEvent(resultsIterable, query));
        return resultsIterable;
    }

    public <A, T> List<T> query(Query<A> query, Function<A, T> entityFunc) {
        return (List)this.queryIterable(query, entityFunc).getIterable();
    }

    public <A, T> DatastoreResultsIterable<T> queryIterable(Query<A> query, Function<A, T> entityFunc) {
        QueryResults results = this.getDatastoreReadWriter().run(query);
        ArrayList resultsList = new ArrayList();
        results.forEachRemaining(e -> resultsList.add(entityFunc.apply(e)));
        DatastoreResultsIterable resultsIterable = new DatastoreResultsIterable(resultsList, results.getCursorAfter());
        this.maybeEmitEvent(new AfterQueryEvent(resultsIterable, query));
        return resultsIterable;
    }

    @Override
    public Iterable<Key> queryKeys(Query<Key> query) {
        Iterable<Key> keys = () -> this.getDatastoreReadWriter().run(query);
        this.maybeEmitEvent(new AfterQueryEvent(keys, query));
        return keys;
    }

    public <T> Collection<T> findAll(Class<T> entityClass) {
        return this.findAll((Class)entityClass, (DatastoreQueryOptions)null);
    }

    public <T> DatastoreResultsIterable<T> queryByExample(Example<T> example, DatastoreQueryOptions queryOptions) {
        return this.query((Query)this.exampleToQuery(example, queryOptions, false), example.getProbeType());
    }

    @Override
    public <T> Iterable<Key> keyQueryByExample(Example<T> example, DatastoreQueryOptions queryOptions) {
        StructuredQuery query = this.exampleToQuery(example, queryOptions, true);
        Iterable<Key> results = () -> this.lambda$keyQueryByExample$4((Query)query);
        this.maybeEmitEvent(new AfterQueryEvent(results, (Query)query));
        return results;
    }

    public <T> DatastoreResultsCollection<T> findAll(Class<T> entityClass, DatastoreQueryOptions queryOptions) {
        DatastorePersistentEntity persistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass);
        EntityQuery.Builder builder = (EntityQuery.Builder)Query.newEntityQueryBuilder().setKind(persistentEntity.kindName());
        DatastoreTemplate.applyQueryOptions((StructuredQuery.Builder)builder, queryOptions, persistentEntity);
        EntityQuery query = builder.build();
        QueryResults queryResults = this.getDatastoreReadWriter().run((Query)query);
        List<T> convertedResults = this.convertEntitiesForRead((Iterator<? extends BaseEntity>)queryResults, entityClass);
        this.maybeEmitEvent(new AfterQueryEvent(convertedResults, (Query)query));
        return new DatastoreResultsCollection<T>(convertedResults, queryResults != null ? queryResults.getCursorAfter() : null);
    }

    public static void applyQueryOptions(StructuredQuery.Builder builder, DatastoreQueryOptions queryOptions, DatastorePersistentEntity<?> persistentEntity) {
        if (persistentEntity.getDiscriminationFieldName() != null && persistentEntity.getDiscriminatorValue() != null) {
            StructuredQuery.PropertyFilter discriminationFilter = StructuredQuery.PropertyFilter.eq((String)persistentEntity.getDiscriminationFieldName(), (String)persistentEntity.getDiscriminatorValue());
            StructuredQuery.Filter filter = builder.build().getFilter();
            if (filter != null) {
                discriminationFilter = StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)filter, (StructuredQuery.Filter[])new StructuredQuery.Filter[]{discriminationFilter});
            }
            builder.setFilter((StructuredQuery.Filter)discriminationFilter);
        }
        if (queryOptions == null) {
            return;
        }
        if (queryOptions.getLimit() != null) {
            builder.setLimit(queryOptions.getLimit());
        }
        if (queryOptions.getCursor() == null && queryOptions.getOffset() != null) {
            builder.setOffset(queryOptions.getOffset().intValue());
        }
        if (queryOptions.getCursor() != null) {
            builder.setStartCursor(queryOptions.getCursor());
        }
        if (queryOptions.getSort() != null && persistentEntity != null) {
            queryOptions.getSort().stream().map(order -> DatastoreTemplate.createOrderBy(persistentEntity, order)).forEachOrdered(orderBy -> builder.addOrderBy(orderBy, new StructuredQuery.OrderBy[0]));
        }
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> entityClass) {
        return this.findById(id, entityClass) != null;
    }

    @Override
    public <A> A performTransaction(Function<DatastoreOperations, A> operations) {
        if (!(this.getDatastoreReadWriter() instanceof Datastore)) {
            throw new DatastoreDataException("This DatastoreReadWriter cannot be used to run transactions. A full Datastore service object is required to run functions as transactions. Ensure that this method was not called in an ongoing transaction.");
        }
        return (A)((Datastore)this.getDatastoreReadWriter()).runInTransaction(readerWriter -> operations.apply(new DatastoreTemplate(() -> readerWriter, this.datastoreEntityConverter, this.datastoreMappingContext, this.objectToKeyFactory)));
    }

    @Override
    public <T> Map<String, T> findByIdAsMap(Key key, Class<T> valueType) {
        Assert.notNull((Object)key, (String)"A non-null Key is required.");
        Assert.notNull(valueType, (String)"A non-null valueType is required.");
        Entity entity = this.getDatastoreReadWriter().get(key);
        return this.datastoreEntityConverter.readAsMap(String.class, ClassTypeInformation.from(valueType), (BaseEntity)entity);
    }

    @Override
    public <V> void writeMap(Key datastoreKey, Map<String, V> map) {
        Assert.notNull((Object)datastoreKey, (String)"A non-null Key is required.");
        Assert.notNull(map, (String)"A non-null map is required.");
        Entity.Builder builder = Entity.newBuilder((Key)datastoreKey);
        map.forEach((key, value) -> {
            Entity.Builder cfr_ignored_0 = (Entity.Builder)builder.set(key, this.datastoreEntityConverter.getConversions().convertOnWriteSingle(value));
        });
        Entity entity = builder.build();
        this.getDatastoreReadWriter().put((FullEntity)entity);
    }

    @Override
    public Key createKey(String kind, Object id) {
        return this.objectToKeyFactory.getKeyFromId(id, kind);
    }

    @Override
    public Key createKey(Class aClass, Object id) {
        return this.objectToKeyFactory.getKeyFromId(id, ((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(aClass)).kindName());
    }

    private static StructuredQuery.OrderBy createOrderBy(DatastorePersistentEntity<?> persistentEntity, Sort.Order order) {
        if (order.isIgnoreCase()) {
            throw new DatastoreDataException("Datastore doesn't support sorting ignoring case");
        }
        if (!order.getNullHandling().equals((Object)Sort.NullHandling.NATIVE)) {
            throw new DatastoreDataException("Datastore supports only NullHandling.NATIVE null handling");
        }
        return new StructuredQuery.OrderBy(((DatastorePersistentProperty)persistentEntity.getPersistentProperty(order.getProperty())).getFieldName(), order.getDirection() == Sort.Direction.DESC ? StructuredQuery.OrderBy.Direction.DESCENDING : StructuredQuery.OrderBy.Direction.ASCENDING);
    }

    private List<Entity> convertToEntityForSave(Object entity, Set<Key> persistedEntities, Key ... ancestors) {
        if (ancestors != null) {
            for (Key ancestor : ancestors) {
                this.validateKey(entity, DatastoreTemplate.keyToPathElement(ancestor));
            }
        }
        Key key = this.getKey(entity, true, ancestors);
        Entity.Builder builder = Entity.newBuilder((Key)key);
        ArrayList<Entity> entitiesToSave = new ArrayList<Entity>();
        this.datastoreEntityConverter.write(entity, builder);
        entitiesToSave.addAll(this.getDescendantEntitiesForSave(entity, key, persistedEntities));
        entitiesToSave.addAll(this.getReferenceEntitiesForSave(entity, builder, persistedEntities));
        entitiesToSave.add(builder.build());
        return entitiesToSave;
    }

    private List<Entity> getReferenceEntitiesForSave(Object entity, Entity.Builder builder, Set<Key> persistedEntities) {
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entity.getClass());
        ArrayList<Entity> entitiesToSave = new ArrayList<Entity>();
        datastorePersistentEntity.doWithAssociations(association -> {
            Value value;
            PersistentProperty persistentProperty = association.getInverse();
            PersistentPropertyAccessor accessor = datastorePersistentEntity.getPropertyAccessor(entity);
            Object val = accessor.getProperty(persistentProperty);
            if (val == null) {
                return;
            }
            if (LazyUtil.isLazyAndNotLoaded(val)) {
                value = LazyUtil.getKeys(val);
            } else if (persistentProperty.isCollectionLike()) {
                Iterable iterableVal = (Iterable)ValueUtil.toListIfArray(val);
                entitiesToSave.addAll(this.getEntitiesForSave(iterableVal, persistedEntities, new Key[0]));
                List keyValues = StreamSupport.stream(iterableVal.spliterator(), false).map(o -> KeyValue.of((Key)this.getKey(o, false, new Key[0]))).collect(Collectors.toList());
                value = ListValue.of(keyValues);
            } else {
                entitiesToSave.addAll(this.getEntitiesForSave(Collections.singletonList(val), persistedEntities, new Key[0]));
                Key key = this.getKey(val, false, new Key[0]);
                value = KeyValue.of((Key)key);
            }
            builder.set(((DatastorePersistentProperty)persistentProperty).getFieldName(), value);
        });
        return entitiesToSave;
    }

    private List<Entity> getDescendantEntitiesForSave(Object entity, Key key, Set<Key> persistedEntities) {
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entity.getClass());
        ArrayList<Entity> entitiesToSave = new ArrayList<Entity>();
        datastorePersistentEntity.doWithDescendantProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)persistentProperty -> {
            PersistentPropertyAccessor accessor = datastorePersistentEntity.getPropertyAccessor(entity);
            Object val = accessor.getProperty(persistentProperty);
            if (val != null) {
                entitiesToSave.addAll(this.getEntitiesForSave((Iterable)ValueUtil.toListIfArray(val), persistedEntities, key));
            }
        }));
        return entitiesToSave;
    }

    public static PathElement keyToPathElement(Key key) {
        Assert.notNull((Object)key, (String)"A non-null key is required");
        return key.getName() != null ? PathElement.of((String)key.getKind(), (String)key.getName()) : PathElement.of((String)key.getKind(), (long)key.getId());
    }

    private void validateKey(Object entity, PathElement ancestorPE) {
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entity.getClass());
        DatastorePersistentProperty idProp = datastorePersistentEntity.getIdPropertyOrFail();
        if (!TypeUtils.isAssignable(BaseKey.class, (Type)idProp.getType())) {
            throw new DatastoreDataException("Only Key types are allowed for descendants id");
        }
        Key key = this.getKey(entity, false, new Key[0]);
        if (key == null || key.getAncestors().stream().anyMatch(pe -> pe.equals((Object)ancestorPE))) {
            return;
        }
        throw new DatastoreDataException("Descendant object has a key without current ancestor");
    }

    public <T> List<T> convertEntitiesForRead(Iterator<? extends BaseEntity> entities, Class<T> entityClass) {
        ReadContext context = new ReadContext();
        return this.convertEntitiesForRead(entities, entityClass, context);
    }

    private <T> List<T> convertEntitiesForRead(Iterator<? extends BaseEntity> entities, Class<T> entityClass, ReadContext context) {
        if (entities == null) {
            return Collections.emptyList();
        }
        ArrayList keys = new ArrayList();
        entities.forEachRemaining(e -> {
            IncompleteKey key = e.getKey();
            context.putReadEntity((BaseKey)key, (BaseEntity)e);
            keys.add(key);
        });
        return this.convertEntitiesForRead(keys, entityClass, context);
    }

    private <T> List<T> convertEntitiesForRead(Collection<? extends BaseKey> keys, Class<T> entityClass, ReadContext context) {
        if (keys == null) {
            return Collections.emptyList();
        }
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass);
        return keys.stream().map(key -> this.convertEntityResolveDescendantsAndReferences(entityClass, datastorePersistentEntity, (BaseKey)key, context)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> T convertEntityResolveDescendantsAndReferences(Class<T> entityClass, DatastorePersistentEntity datastorePersistentEntity, BaseKey key, ReadContext context) {
        Object convertedObject;
        if (context.converted(key)) {
            convertedObject = context.getConvertedEntity(key);
        } else {
            BaseEntity readEntity = context.getReadEntity(key);
            convertedObject = this.datastoreEntityConverter.read(entityClass, readEntity);
            context.putConvertedEntity(key, convertedObject);
            context.removeReadEntity(key);
            if (convertedObject != null) {
                this.resolveDescendantProperties(datastorePersistentEntity, readEntity, convertedObject, context);
                this.resolveReferenceProperties(datastorePersistentEntity, readEntity, convertedObject, context);
            }
        }
        return (T)convertedObject;
    }

    private <T> void resolveReferenceProperties(DatastorePersistentEntity datastorePersistentEntity, BaseEntity entity, T convertedObject, ReadContext context) {
        datastorePersistentEntity.doWithAssociations(association -> {
            Class type;
            Object referenced;
            DatastorePersistentProperty referenceProperty = (DatastorePersistentProperty)association.getInverse();
            String fieldName = referenceProperty.getFieldName();
            if (entity.contains(fieldName) && !entity.isNull(fieldName) && (referenced = this.computeReferencedField(entity, context, referenceProperty, fieldName, type = referenceProperty.getType())) != null) {
                datastorePersistentEntity.getPropertyAccessor(convertedObject).setProperty((PersistentProperty)referenceProperty, referenced);
            }
        });
    }

    private <T> T computeReferencedField(BaseEntity entity, ReadContext context, DatastorePersistentProperty referenceProperty, String fieldName, Class<T> type) {
        Object referenced;
        if (referenceProperty.isLazyLoaded()) {
            DatastoreReaderWriter originalTx = this.getDatastoreReadWriter();
            referenced = LazyUtil.wrapSimpleLazyProxy(() -> {
                if (this.getDatastoreReadWriter() != originalTx) {
                    throw new DatastoreDataException("Lazy load should be invoked within the same transaction");
                }
                return this.findReferenced(entity, referenceProperty, context);
            }, type, entity.getValue(fieldName));
        } else {
            referenced = this.findReferenced(entity, referenceProperty, context);
        }
        return (T)referenced;
    }

    private Object findReferenced(BaseEntity entity, DatastorePersistentProperty referencePersistentProperty, ReadContext context) {
        String fieldName = referencePersistentProperty.getFieldName();
        try {
            List referencedList;
            Object referenced = referencePersistentProperty.isCollectionLike() ? this.fetchReferenced(referencePersistentProperty, context, this.valuesToKeys(entity.getList(fieldName))) : ((referencedList = this.findAllById(Collections.singleton(entity.getKey(fieldName)), referencePersistentProperty.getType(), context)).isEmpty() ? null : referencedList.get(0));
            return referenced;
        }
        catch (ClassCastException ex) {
            throw new DatastoreDataException("Error loading reference property " + fieldName + ".Reference properties must be stored as Keys or lists of Keys in Cloud Datastore for singular or multiple references, respectively.");
        }
    }

    private Object fetchReferenced(DatastorePersistentProperty referencePersistentProperty, ReadContext context, Set<Key> keys) {
        Class referencedType = referencePersistentProperty.getComponentType();
        return this.datastoreEntityConverter.getConversions().convertOnRead(this.findAllById(keys, referencedType, context), referencePersistentProperty.getType(), referencedType);
    }

    private Set<Key> valuesToKeys(List<Value<Key>> keyValues) {
        return keyValues.stream().map(Value::get).collect(Collectors.toSet());
    }

    private <T> void resolveDescendantProperties(DatastorePersistentEntity datastorePersistentEntity, BaseEntity entity, T convertedObject, ReadContext context) {
        datastorePersistentEntity.doWithDescendantProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)descendantPersistentProperty -> {
            Class descendantType = descendantPersistentProperty.getComponentType();
            Key entityKey = (Key)entity.getKey();
            Key ancestorKey = KeyUtil.getKeyWithoutAncestors(entityKey);
            EntityQuery descendantQuery = ((EntityQuery.Builder)((EntityQuery.Builder)Query.newEntityQueryBuilder().setKind(((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(descendantType)).kindName())).setFilter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.hasAncestor((Key)ancestorKey))).build();
            List entities = this.convertEntitiesForRead((Iterator<? extends BaseEntity>)this.getDatastoreReadWriter().run((Query)descendantQuery), descendantType, context);
            datastorePersistentEntity.getPropertyAccessor(convertedObject).setProperty(descendantPersistentProperty, this.datastoreEntityConverter.getConversions().convertOnRead(entities, descendantPersistentProperty.getType(), descendantType));
        }));
    }

    private Key getKeyFromId(Object id, Class entityClass) {
        return this.objectToKeyFactory.getKeyFromId(id, ((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass)).kindName());
    }

    @Override
    public Key getKey(Object entity) {
        return this.getKey(entity, false, new Key[0]);
    }

    private Key getKey(Object entity, boolean allocateKey, Key ... ancestors) {
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entity.getClass());
        DatastorePersistentProperty idProp = datastorePersistentEntity.getIdPropertyOrFail();
        if (datastorePersistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProp) == null && allocateKey) {
            return this.objectToKeyFactory.allocateKeyForObject(entity, datastorePersistentEntity, ancestors);
        }
        return this.objectToKeyFactory.getKeyFromObject(entity, datastorePersistentEntity);
    }

    private Key[] findAllKeys(Class entityClass) {
        Iterable<Key> keysFound = this.queryKeys((Query<Key>)((KeyQuery.Builder)Query.newKeyQueryBuilder().setKind(((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass)).kindName())).build());
        return (Key[])StreamSupport.stream(keysFound.spliterator(), false).toArray(Key[]::new);
    }

    private <T> Set<Key> getKeysFromIds(Iterable<?> ids, Class<T> entityClass) {
        HashSet<Key> keys = new HashSet<Key>();
        ids.forEach(x -> keys.add(this.getKeyFromId(x, entityClass)));
        return keys;
    }

    private DatastoreReaderWriter getDatastoreReadWriter() {
        DatastoreTransactionManager.Tx tx;
        if (TransactionSynchronizationManager.isActualTransactionActive() && (tx = (DatastoreTransactionManager.Tx)TransactionSynchronizationManager.getResource((Object)this.datastore.get())) != null && tx.getTransaction() != null) {
            return tx.getTransaction();
        }
        return this.datastore.get();
    }

    private <T> StructuredQuery exampleToQuery(Example<T> example, DatastoreQueryOptions queryOptions, boolean keyQuery) {
        this.validateExample(example);
        Object probe = example.getProbe();
        FullEntity.Builder probeEntityBuilder = Entity.newBuilder();
        this.datastoreEntityConverter.write(probe, probeEntityBuilder);
        FullEntity probeEntity = probeEntityBuilder.build();
        DatastorePersistentEntity persistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(example.getProbeType());
        KeyQuery.Builder builder = keyQuery ? Query.newKeyQueryBuilder() : Query.newEntityQueryBuilder();
        builder.setKind(persistentEntity.kindName());
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(example.getMatcher());
        matcherAccessor.getPropertySpecifiers();
        LinkedList filters = new LinkedList();
        persistentEntity.doWithColumnBackedProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)persistentProperty -> {
            if (!example.getMatcher().isIgnoredPath(persistentProperty.getName())) {
                Value value;
                String fieldName = persistentProperty.getFieldName();
                if (persistentProperty.isIdProperty()) {
                    PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(probe);
                    value = KeyValue.of((Key)this.createKey(persistentEntity.kindName(), accessor.getProperty(persistentProperty)));
                } else {
                    value = probeEntity.getValue(fieldName);
                }
                if (value instanceof NullValue && example.getMatcher().getNullHandler() != ExampleMatcher.NullHandler.INCLUDE) {
                    return;
                }
                filters.add(StructuredQuery.PropertyFilter.eq((String)fieldName, (Value)value));
            }
        }));
        if (!filters.isEmpty()) {
            builder.setFilter((StructuredQuery.Filter)StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)((StructuredQuery.Filter)filters.pop()), (StructuredQuery.Filter[])filters.toArray(new StructuredQuery.Filter[0])));
        }
        DatastoreTemplate.applyQueryOptions((StructuredQuery.Builder)builder, queryOptions, persistentEntity);
        return builder.build();
    }

    private <T> void validateExample(Example<T> example) {
        Assert.notNull(example, (String)"A non-null example is expected");
        ExampleMatcher matcher = example.getMatcher();
        if (!matcher.isAllMatching()) {
            throw new DatastoreDataException("Unsupported MatchMode. Only MatchMode.ALL is supported");
        }
        if (matcher.isIgnoreCaseEnabled()) {
            throw new DatastoreDataException("Ignore case matching is not supported");
        }
        if (matcher.getDefaultStringMatcher() != ExampleMatcher.StringMatcher.EXACT && matcher.getDefaultStringMatcher() != ExampleMatcher.StringMatcher.DEFAULT) {
            throw new DatastoreDataException("Unsupported StringMatcher. Only EXACT and DEFAULT are supported");
        }
        Optional<String> path = example.getMatcher().getIgnoredPaths().stream().filter(s -> s.contains(".")).findFirst();
        if (path.isPresent()) {
            throw new DatastoreDataException("Ignored paths deeper than 1 are not supported");
        }
        if (matcher.getPropertySpecifiers().hasValues()) {
            throw new DatastoreDataException("Property matchers are not supported");
        }
    }

    private void maybeEmitEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    void setMaxWriteSize(int maxWriteSize) {
        this.maxWriteSize = maxWriteSize;
    }

    private /* synthetic */ Iterator lambda$keyQueryByExample$4(Query query) {
        return this.getDatastoreReadWriter().run(query);
    }

    class ReadContext {
        private final Map<BaseKey, Object> convertedEntities = new HashMap<BaseKey, Object>();
        private final Map<BaseKey, BaseEntity> readEntities = new HashMap<BaseKey, BaseEntity>();

        ReadContext() {
        }

        void putConvertedEntity(BaseKey key, Object entity) {
            this.convertedEntities.put(key, entity);
        }

        Object getConvertedEntity(BaseKey key) {
            return this.convertedEntities.get(key);
        }

        boolean notCached(BaseKey key) {
            return !this.convertedEntities.containsKey(key) && !this.readEntities.containsKey(key);
        }

        boolean converted(BaseKey key) {
            return this.convertedEntities.containsKey(key);
        }

        BaseEntity getReadEntity(BaseKey key) {
            return this.readEntities.get(key);
        }

        void putReadEntity(BaseKey key, BaseEntity entity) {
            this.readEntities.put(key, entity);
        }

        void removeReadEntity(BaseKey key) {
            this.readEntities.remove(key);
        }
    }
}

