/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.query;

import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.cloud.gcp.core.util.MapBuilder;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreQueryOptions;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreResultsIterable;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.repository.query.AbstractDatastoreQuery;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastorePageable;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastoreQueryMethod;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class PartTreeDatastoreQuery<T>
extends AbstractDatastoreQuery<T> {
    private final PartTree tree;
    private final DatastorePersistentEntity datastorePersistentEntity;
    private List<Part> filterParts;
    private static final Map<Part.Type, BiFunction<String, Value, StructuredQuery.PropertyFilter>> FILTER_FACTORIES = new MapBuilder().put((Object)Part.Type.SIMPLE_PROPERTY, StructuredQuery.PropertyFilter::eq).put((Object)Part.Type.GREATER_THAN_EQUAL, StructuredQuery.PropertyFilter::ge).put((Object)Part.Type.GREATER_THAN, StructuredQuery.PropertyFilter::gt).put((Object)Part.Type.LESS_THAN_EQUAL, StructuredQuery.PropertyFilter::le).put((Object)Part.Type.LESS_THAN, StructuredQuery.PropertyFilter::lt).build();

    public PartTreeDatastoreQuery(DatastoreQueryMethod queryMethod, DatastoreTemplate datastoreTemplate, DatastoreMappingContext datastoreMappingContext, Class<T> entityType) {
        super(queryMethod, datastoreTemplate, datastoreMappingContext, entityType);
        this.tree = new PartTree(queryMethod.getName(), entityType);
        this.datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(this.entityType);
        this.validateAndSetFilterParts();
    }

    private void validateAndSetFilterParts() {
        if (this.tree.isDistinct()) {
            throw new UnsupportedOperationException("Cloud Datastore structured queries do not support the Distinct keyword.");
        }
        List parts = this.tree.get().collect(Collectors.toList());
        if (parts.size() > 0) {
            if (parts.get(0) instanceof PartTree.OrPart && parts.size() > 1) {
                throw new DatastoreDataException("Cloud Datastore only supports multiple filters combined with AND.");
            }
            this.filterParts = this.tree.getParts().get().collect(Collectors.toList());
        } else {
            this.filterParts = Collections.emptyList();
        }
    }

    public Object execute(Object[] parameters) {
        Class returnedObjectType = this.getQueryMethod().getReturnedObjectType();
        if (this.isPageQuery()) {
            Long totalCount;
            ExecutionResult executionResult = (ExecutionResult)this.execute(parameters, returnedObjectType, List.class, false);
            List resultEntries = (List)executionResult.getPayload();
            ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
            Pageable pageableParam = paramAccessor.getPageable();
            if (pageableParam instanceof DatastorePageable) {
                Long previousCount = ((DatastorePageable)pageableParam).getTotalCount();
                Assert.notNull((Object)previousCount, (String)"Previous total count can not be null.");
                totalCount = ((DatastorePageable)pageableParam).getTotalCount();
            } else {
                totalCount = (Long)this.execute(parameters, Long.class, null, true);
            }
            Pageable pageable = DatastorePageable.from(pageableParam, executionResult.getCursor(), totalCount);
            return new PageImpl(resultEntries, pageable, totalCount.longValue());
        }
        if (this.isSliceQuery()) {
            return this.executeSliceQuery(parameters);
        }
        Object result = this.execute(parameters, returnedObjectType, ((DatastoreQueryMethod)this.getQueryMethod()).getCollectionReturnType(), false);
        Object object = result = result instanceof ExecutionResult ? ((ExecutionResult)result).getPayload() : result;
        if (result == null) {
            if (((DatastoreQueryMethod)this.getQueryMethod()).isOptionalReturnType()) {
                return Optional.empty();
            }
            if (!((DatastoreQueryMethod)this.getQueryMethod()).isNullable()) {
                throw new EmptyResultDataAccessException("Expecting at least 1 result, but none found", 1);
            }
        }
        return result;
    }

    private Object execute(Object[] parameters, Class returnedElementType, Class<?> collectionType, boolean total) {
        Supplier<StructuredQuery.Builder> queryBuilderSupplier = Query::newKeyQueryBuilder;
        Function<Object, Object> mapper = Function.identity();
        boolean returnedTypeIsNumber = Number.class.isAssignableFrom(returnedElementType) || returnedElementType == Integer.TYPE || returnedElementType == Long.TYPE;
        boolean isCountingQuery = this.tree.isCountProjection() || this.tree.isDelete() && returnedTypeIsNumber || total;
        Collector collector = Collectors.toList();
        if (isCountingQuery && !this.tree.isDelete()) {
            collector = Collectors.counting();
        } else if (this.tree.isExistsProjection()) {
            collector = Collectors.collectingAndThen(Collectors.counting(), count -> count > 0L);
        } else if (!returnedTypeIsNumber) {
            queryBuilderSupplier = Query::newEntityQueryBuilder;
            mapper = this::processRawObjectForProjection;
        }
        StructuredQuery.Builder structredQueryBuilder = queryBuilderSupplier.get();
        structredQueryBuilder.setKind(this.datastorePersistentEntity.kindName());
        boolean singularResult = !isCountingQuery && collectionType == null && !this.tree.isDelete();
        DatastoreResultsIterable<?> rawResults = this.getDatastoreTemplate().queryKeysOrEntities((Query)this.applyQueryBody(parameters, structredQueryBuilder, total, singularResult, null), this.entityType);
        List result = StreamSupport.stream(rawResults.spliterator(), false).map(mapper).collect(collector);
        if (this.tree.isDelete()) {
            this.deleteFoundEntities(returnedTypeIsNumber, result);
        }
        if (!this.tree.isExistsProjection() && !isCountingQuery) {
            return new ExecutionResult(this.convertResultCollection(result, collectionType), rawResults.getCursor());
        }
        if (isCountingQuery && this.tree.isDelete()) {
            return result.size();
        }
        return result;
    }

    private Slice executeSliceQuery(Object[] parameters) {
        EntityQuery.Builder builder = (EntityQuery.Builder)StructuredQuery.newEntityQueryBuilder().setKind(this.datastorePersistentEntity.kindName());
        StructuredQuery query = this.applyQueryBody(parameters, (StructuredQuery.Builder)builder, false, false, null);
        DatastoreResultsIterable<?> resultList = this.datastoreTemplate.queryKeysOrEntities((Query)query, this.entityType);
        ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        Pageable pageable = DatastorePageable.from(paramAccessor.getPageable(), resultList.getCursor(), null);
        EntityQuery.Builder builderNext = (EntityQuery.Builder)StructuredQuery.newEntityQueryBuilder().setKind(this.datastorePersistentEntity.kindName());
        StructuredQuery queryNext = this.applyQueryBody(parameters, (StructuredQuery.Builder)builderNext, false, true, resultList.getCursor());
        Iterable datastoreResultsList = this.datastoreTemplate.query((Query)queryNext, x -> x);
        List result = StreamSupport.stream(resultList.spliterator(), false).collect(Collectors.toList());
        return (Slice)this.processRawObjectForProjection(new SliceImpl(result, pageable, !datastoreResultsList.isEmpty()));
    }

    Object convertResultCollection(Object result, Class<?> collectionType) {
        if (collectionType == null) {
            List list = (List)result;
            return list.isEmpty() ? null : list.get(0);
        }
        return this.getDatastoreTemplate().getDatastoreEntityConverter().getConversions().convertOnRead(result, collectionType, this.getQueryMethod().getReturnedObjectType());
    }

    private void deleteFoundEntities(boolean returnedTypeIsNumber, Iterable rawResults) {
        if (returnedTypeIsNumber) {
            this.getDatastoreTemplate().deleteAllById(rawResults, this.entityType);
        } else {
            this.getDatastoreTemplate().deleteAll(rawResults);
        }
    }

    private StructuredQuery applyQueryBody(Object[] parameters, StructuredQuery.Builder builder, boolean total, boolean singularResult, Cursor cursor) {
        ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        if (this.tree.hasPredicate()) {
            this.applySelectWithFilter(parameters, builder);
        }
        Pageable pageable = paramAccessor.getPageable();
        Integer limit = null;
        Integer offset = null;
        if (singularResult || this.tree.isExistsProjection()) {
            limit = 1;
        } else if (this.tree.isLimiting()) {
            limit = this.tree.getMaxResults();
        }
        if (!singularResult && !total && pageable.isPaged()) {
            limit = pageable.getPageSize();
        }
        Sort sort = this.tree.getSort();
        if (this.getQueryMethod().getParameters().hasPageableParameter()) {
            sort = sort.and(pageable.getSort());
        }
        if (this.getQueryMethod().getParameters().hasSortParameter()) {
            sort = sort.and(paramAccessor.getSort());
        }
        if (pageable.isPaged() && !total) {
            offset = (int)pageable.getOffset();
        }
        Cursor cursorToApply = null;
        if (cursor != null) {
            cursorToApply = cursor;
        } else if (pageable instanceof DatastorePageable) {
            cursorToApply = ((DatastorePageable)pageable).toCursor();
        }
        DatastoreTemplate.applyQueryOptions(builder, new DatastoreQueryOptions.Builder().setLimit(limit).setOffset(offset).setSort(sort).setCursor(cursorToApply).build(), this.datastorePersistentEntity);
        return builder.build();
    }

    private void applySelectWithFilter(Object[] parameters, StructuredQuery.Builder builder) {
        Iterator<Object> it = Arrays.asList(parameters).iterator();
        StructuredQuery.Filter[] filters = (StructuredQuery.Filter[])this.filterParts.stream().map(part -> {
            DatastorePersistentProperty persistentProperty = (DatastorePersistentProperty)this.datastorePersistentEntity.getPersistentProperty(part.getProperty().getSegment());
            if (part.getType() == Part.Type.IS_NULL) {
                return StructuredQuery.PropertyFilter.isNull((String)persistentProperty.getFieldName());
            }
            BiFunction<String, Value, StructuredQuery.PropertyFilter> filterFactory = FILTER_FACTORIES.get(part.getType());
            if (filterFactory == null) {
                throw new DatastoreDataException("Unsupported predicate keyword: " + part.getType());
            }
            if (!it.hasNext()) {
                throw new DatastoreDataException("Too few parameters are provided for query method: " + this.getQueryMethod().getName());
            }
            Value convertedValue = this.convertParam(persistentProperty, it.next());
            return filterFactory.apply(persistentProperty.getFieldName(), convertedValue);
        }).toArray(StructuredQuery.Filter[]::new);
        builder.setFilter((StructuredQuery.Filter)(filters.length > 1 ? StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)filters[0], (StructuredQuery.Filter[])Arrays.copyOfRange(filters, 1, filters.length)) : filters[0]));
    }

    private Value convertParam(DatastorePersistentProperty persistentProperty, Object val) {
        if (persistentProperty.isAssociation() && this.datastoreMappingContext.hasPersistentEntityFor(val.getClass())) {
            return KeyValue.of((Key)this.datastoreTemplate.getKey(val));
        }
        if (persistentProperty.isIdProperty()) {
            return KeyValue.of((Key)this.datastoreTemplate.createKey(this.datastorePersistentEntity.kindName(), val));
        }
        return this.datastoreTemplate.getDatastoreEntityConverter().getConversions().convertOnWriteSingle(val);
    }

    private static class ExecutionResult {
        Object payload;
        Cursor cursor;

        ExecutionResult(Object result, Cursor cursor) {
            this.payload = result;
            this.cursor = cursor;
        }

        public Object getPayload() {
            return this.payload;
        }

        public Cursor getCursor() {
            return this.cursor;
        }
    }
}

