/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.support;

import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntityInformation;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastoreQueryLookupStrategy;
import org.springframework.cloud.gcp.data.datastore.repository.support.SimpleDatastoreRepository;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DatastoreRepositoryFactory
extends RepositoryFactorySupport
implements ApplicationContextAware {
    private final DatastoreMappingContext datastoreMappingContext;
    private final DatastoreTemplate datastoreTemplate;
    private ApplicationContext applicationContext;

    DatastoreRepositoryFactory(DatastoreMappingContext datastoreMappingContext, DatastoreTemplate datastoreTemplate) {
        Assert.notNull((Object)((Object)datastoreMappingContext), (String)"A non-null Datastore mapping context is required.");
        Assert.notNull((Object)datastoreTemplate, (String)"A non-null Datastore template object is required.");
        this.datastoreMappingContext = datastoreMappingContext;
        this.datastoreTemplate = datastoreTemplate;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        DatastorePersistentEntity entity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException("Could not lookup mapping metadata for domain class: " + domainClass.getName());
        }
        return new DatastorePersistentEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.datastoreTemplate, metadata.getDomainType()});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleDatastoreRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new DatastoreQueryLookupStrategy(this.datastoreMappingContext, this.datastoreTemplate, this.delegateContextProvider(evaluationContextProvider)));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private QueryMethodEvaluationContextProvider delegateContextProvider(final QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return new QueryMethodEvaluationContextProvider(){

            public <T extends Parameters<?, ?>> EvaluationContext getEvaluationContext(T parameters, Object[] parameterValues) {
                StandardEvaluationContext evaluationContext = (StandardEvaluationContext)evaluationContextProvider.getEvaluationContext(parameters, parameterValues);
                evaluationContext.setRootObject((Object)DatastoreRepositoryFactory.this.applicationContext);
                evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
                evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)DatastoreRepositoryFactory.this.applicationContext));
                return evaluationContext;
            }
        };
    }
}

