/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core.convert;

import com.google.cloud.Timestamp;
import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.GqlQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.LatLng;
import com.google.cloud.datastore.LatLngValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.TimestampValue;
import com.google.cloud.datastore.Value;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public abstract class DatastoreNativeTypes {
    public static final Set<Class<?>> DATASTORE_NATIVE_TYPES;
    public static final Set<Class<?>> ID_TYPES;
    private static final Map<Class<?>, Function<?, Value<?>>> DATASTORE_TYPE_WRAPPERS;
    private static final Map<Class<?>, Function<GqlQuery.Builder, BiFunction<String, Object, GqlQuery.Builder>>> GQL_PARAM_BINDING_FUNC_MAP;
    public static final SimpleTypeHolder HOLDER;

    public static boolean isNativeType(Class aClass) {
        return aClass == null || DATASTORE_NATIVE_TYPES.contains(aClass);
    }

    public static Value wrapValue(Object propertyVal) {
        if (propertyVal == null) {
            return new NullValue();
        }
        Class propertyClass = DatastoreNativeTypes.getTypeForWrappingInDatastoreValue(propertyVal);
        Function<?, Value<?>> wrapper = DATASTORE_TYPE_WRAPPERS.get(propertyClass);
        if (wrapper != null) {
            return wrapper.apply(propertyVal);
        }
        throw new DatastoreDataException("Unable to convert " + propertyClass + " to Datastore supported type.");
    }

    public static void bindValueToGqlBuilder(GqlQuery.Builder builder, String tagName, Object val) {
        Class valClass = DatastoreNativeTypes.getTypeForWrappingInDatastoreValue(val);
        if (!GQL_PARAM_BINDING_FUNC_MAP.containsKey(valClass)) {
            throw new DatastoreDataException("Param value for GQL annotated query is not a supported Cloud Datastore GQL param type: " + valClass);
        }
        GqlQuery.Builder unusued = GQL_PARAM_BINDING_FUNC_MAP.get(valClass).apply(builder).apply(tagName, val);
    }

    private static Class getTypeForWrappingInDatastoreValue(Object val) {
        return val.getClass().isEnum() ? Enum.class : val.getClass();
    }

    static {
        DATASTORE_TYPE_WRAPPERS = ImmutableMap.builder().put(Blob.class, BlobValue::of).put(Boolean.class, BooleanValue::of).put(Long.class, LongValue::of).put(Double.class, DoubleValue::of).put(LatLng.class, LatLngValue::of).put(Timestamp.class, TimestampValue::of).put(String.class, StringValue::of).put(Enum.class, x -> StringValue.of((String)x.name())).put(Entity.class, EntityValue::of).put(Key.class, KeyValue::of).build();
        DATASTORE_NATIVE_TYPES = ImmutableSet.builder().addAll(DATASTORE_TYPE_WRAPPERS.keySet()).build();
        ID_TYPES = ImmutableSet.builder().add(String.class).add(Long.class).build();
        GQL_PARAM_BINDING_FUNC_MAP = ImmutableMap.builder().put(Cursor.class, builder -> (s, o) -> builder.setBinding(s, (Cursor)o)).put(String.class, builder -> (s, o) -> builder.setBinding(s, new String[]{(String)o})).put(Enum.class, builder -> (s, o) -> builder.setBinding(s, new String[]{((Enum)o).name()})).put(String[].class, builder -> (s, o) -> builder.setBinding(s, (String[])o)).put(Long.class, builder -> (s, o) -> builder.setBinding(s, new long[]{(Long)o})).put(Long[].class, builder -> (s, o) -> builder.setBinding(s, Stream.of((Long[])o).mapToLong(Long::longValue).toArray())).put(long[].class, builder -> (s, o) -> builder.setBinding(s, (long[])o)).put(Double.class, builder -> (s, o) -> builder.setBinding(s, new double[]{(Double)o})).put(Double[].class, builder -> (s, o) -> builder.setBinding(s, Stream.of((Double[])o).mapToDouble(Double::doubleValue).toArray())).put(double[].class, builder -> (s, o) -> builder.setBinding(s, (double[])o)).put(Boolean.class, builder -> (s, o) -> builder.setBinding(s, new boolean[]{(Boolean)o})).put(Boolean[].class, builder -> (s, o) -> builder.setBinding(s, Booleans.toArray(Arrays.asList((Boolean[])o)))).put(boolean[].class, builder -> (s, o) -> builder.setBinding(s, (boolean[])o)).put(Timestamp.class, builder -> (s, o) -> builder.setBinding(s, new Timestamp[]{(Timestamp)o})).put(Timestamp[].class, builder -> (s, o) -> builder.setBinding(s, (Timestamp[])o)).put(Key.class, builder -> (s, o) -> builder.setBinding(s, new Key[]{(Key)o})).put(Key[].class, builder -> (s, o) -> builder.setBinding(s, (Key[])o)).put(Blob.class, builder -> (s, o) -> builder.setBinding(s, new Blob[]{(Blob)o})).put(Blob[].class, builder -> (s, o) -> builder.setBinding(s, (Blob[])o)).build();
        HOLDER = new SimpleTypeHolder(DATASTORE_NATIVE_TYPES, true);
    }
}

