/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core.convert;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreEntityConverter;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreNativeTypes;
import org.springframework.cloud.gcp.data.datastore.core.convert.ObjectToKeyFactory;
import org.springframework.cloud.gcp.data.datastore.core.convert.ReadWriteConversions;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.core.mapping.EmbeddedType;
import org.springframework.cloud.gcp.data.datastore.core.util.ValueUtil;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TwoStepsConversions
implements ReadWriteConversions {
    private static final Converter<Blob, byte[]> BLOB_TO_BYTE_ARRAY_CONVERTER = new Converter<Blob, byte[]>(){

        public byte[] convert(Blob source) {
            return source.toByteArray();
        }
    };
    private static final Converter<byte[], Blob> BYTE_ARRAY_TO_BLOB_CONVERTER = new Converter<byte[], Blob>(){

        public Blob convert(byte[] source) {
            return Blob.copyFrom((byte[])source);
        }
    };
    private final GenericConversionService conversionService;
    private final GenericConversionService internalConversionService;
    private final CustomConversions customConversions;
    private final ObjectToKeyFactory objectToKeyFactory;
    private DatastoreEntityConverter datastoreEntityConverter;
    private final Map<Class, Optional<Class<?>>> writeConverters = new ConcurrentHashMap();

    public TwoStepsConversions(CustomConversions customConversions, ObjectToKeyFactory objectToKeyFactory) {
        this.objectToKeyFactory = objectToKeyFactory;
        this.conversionService = new DefaultConversionService();
        this.internalConversionService = new DefaultConversionService();
        this.customConversions = customConversions;
        this.customConversions.registerConvertersIn((ConverterRegistry)this.conversionService);
        this.internalConversionService.addConverter(BYTE_ARRAY_TO_BLOB_CONVERTER);
        this.internalConversionService.addConverter(BLOB_TO_BYTE_ARRAY_CONVERTER);
    }

    @Override
    public <T> T convertOnRead(Object val, Class targetCollectionType, Class targetComponentType) {
        return this.convertOnRead(val, EmbeddedType.NOT_EMBEDDED, targetCollectionType, (TypeInformation)ClassTypeInformation.from((Class)targetComponentType));
    }

    @Override
    public <T> T convertOnRead(Object val, EmbeddedType embeddedType, TypeInformation targetTypeInformation) {
        TypeInformation componentTypeInformation;
        Class collectionType = null;
        if (targetTypeInformation.isCollectionLike()) {
            componentTypeInformation = targetTypeInformation.getComponentType();
            collectionType = targetTypeInformation.getType();
        } else {
            componentTypeInformation = targetTypeInformation;
        }
        return this.convertOnRead(val, embeddedType, collectionType, componentTypeInformation);
    }

    private <T> T convertOnRead(Object val, EmbeddedType embeddedType, Class targetCollectionType, TypeInformation targetComponentType) {
        BiFunction<Object, TypeInformation, Object> readConverter;
        if (val == null) {
            return null;
        }
        switch (embeddedType) {
            case EMBEDDED_MAP: {
                readConverter = (x, typeInformation) -> this.convertOnReadSingleEmbeddedMap(x, ((TypeInformation)typeInformation.getTypeArguments().get(0)).getType(), (TypeInformation)typeInformation.getTypeArguments().get(1));
                break;
            }
            case EMBEDDED_ENTITY: {
                readConverter = this::convertOnReadSingleEmbedded;
                break;
            }
            case NOT_EMBEDDED: {
                readConverter = this::convertOnReadSingle;
                break;
            }
            default: {
                throw new DatastoreDataException("Unexpected property embedded type: " + (Object)((Object)embeddedType));
            }
        }
        if (ValueUtil.isCollectionLike(val.getClass()) && targetCollectionType != null && targetComponentType != null) {
            try {
                List elements = (val.getClass().isArray() ? Arrays.asList(val) : (List<Object>)val).stream().map(v -> readConverter.apply(v instanceof Value ? ((Value)v).get() : v, targetComponentType)).collect(Collectors.toList());
                return this.convertCollection(elements, targetCollectionType);
            }
            catch (DatastoreDataException | ConversionException ex) {
                throw new DatastoreDataException("Unable process elements of a collection", (Throwable)ex);
            }
        }
        return (T)readConverter.apply(val, targetComponentType);
    }

    private <T, R> Map<T, R> convertOnReadSingleEmbeddedMap(Object value, Class<T> keyType, TypeInformation<R> targetComponentType) {
        Assert.notNull((Object)value, (String)"Cannot convert a null value.");
        if (value instanceof BaseEntity) {
            return this.datastoreEntityConverter.readAsMap(keyType, targetComponentType, (BaseEntity)value);
        }
        throw new DatastoreDataException("Embedded entity was expected, but " + value.getClass() + " found");
    }

    private <T> T convertOnReadSingleEmbedded(Object value, TypeInformation<?> targetTypeInformation) {
        Assert.notNull((Object)value, (String)"Cannot convert a null value.");
        if (value instanceof BaseEntity) {
            return (T)this.datastoreEntityConverter.read(targetTypeInformation.getType(), (BaseEntity)value);
        }
        throw new DatastoreDataException("Embedded entity was expected, but " + value.getClass() + " found");
    }

    private <T> T convertOnReadSingle(Object val, TypeInformation<?> targetTypeInformation) {
        Class targetType = targetTypeInformation.getType();
        Assert.notNull((Object)val, (String)"Cannot convert a null value.");
        Class<?> sourceType = val.getClass();
        Object result = null;
        TypeTargets typeTargets = this.computeTypeTargets(targetType);
        if (typeTargets.getFirstStepTarget() == null && typeTargets.getSecondStepTarget() == null && ClassUtils.isAssignable((Class)targetType, val.getClass())) {
            result = val;
        } else if (typeTargets.getFirstStepTarget() == null && typeTargets.getSecondStepTarget() != null) {
            result = this.internalConversionService.convert(val, targetType);
        } else if (typeTargets.getFirstStepTarget() != null && typeTargets.getSecondStepTarget() == null) {
            result = this.conversionService.convert(val, targetType);
        } else if (typeTargets.getFirstStepTarget() != null && typeTargets.getSecondStepTarget() != null) {
            Object secondStepVal = this.internalConversionService.convert(val, typeTargets.getFirstStepTarget());
            result = this.conversionService.convert(secondStepVal, targetType);
        } else if (DatastoreNativeTypes.isNativeType(sourceType) && this.conversionService.canConvert(sourceType, targetType)) {
            result = this.conversionService.convert(val, targetType);
        } else if (DatastoreNativeTypes.isNativeType(sourceType) && this.internalConversionService.canConvert(sourceType, targetType)) {
            result = this.internalConversionService.convert(val, targetType);
        }
        if (result != null) {
            return (T)result;
        }
        throw new DatastoreDataException("Unable to convert " + val.getClass() + " to " + targetType);
    }

    @Override
    public Value convertOnWrite(Object proppertyVal, DatastorePersistentProperty persistentProperty) {
        return this.convertOnWrite(proppertyVal, persistentProperty.getEmbeddedType(), persistentProperty.getFieldName(), persistentProperty.getTypeInformation());
    }

    private Value convertOnWrite(Object proppertyVal, EmbeddedType embeddedType, String fieldName, TypeInformation typeInformation) {
        Object val = proppertyVal;
        Function<Object, Value> writeConverter = this::convertOnWriteSingle;
        if (proppertyVal != null) {
            switch (embeddedType) {
                case EMBEDDED_MAP: {
                    writeConverter = x -> this.convertOnWriteSingleEmbeddedMap(x, fieldName, (TypeInformation)typeInformation.getTypeArguments().get(1));
                    break;
                }
                case EMBEDDED_ENTITY: {
                    writeConverter = x -> this.convertOnWriteSingleEmbedded(x, fieldName);
                    break;
                }
                case NOT_EMBEDDED: {
                    writeConverter = this::convertOnWriteSingle;
                    break;
                }
                default: {
                    throw new DatastoreDataException("Unexpected property embedded type: " + (Object)((Object)embeddedType));
                }
            }
        }
        if ((val = ValueUtil.toListIfArray(val)) instanceof Iterable) {
            ArrayList<Value> values = new ArrayList<Value>();
            for (Object propEltValue : (Iterable)val) {
                values.add(writeConverter.apply(propEltValue));
            }
            return ListValue.of(values);
        }
        return writeConverter.apply(val);
    }

    private EntityValue applyEntityValueBuilder(String kindName, Consumer<FullEntity.Builder> consumer) {
        IncompleteKey key = this.objectToKeyFactory.getIncompleteKey(kindName);
        FullEntity.Builder builder = FullEntity.newBuilder((IncompleteKey)key);
        consumer.accept(builder);
        return EntityValue.of((FullEntity)builder.build());
    }

    private EntityValue convertOnWriteSingleEmbeddedMap(Object val, String kindName, TypeInformation valueTypeInformation) {
        return this.applyEntityValueBuilder(kindName, builder -> {
            Map map = (Map)val;
            for (Object key : map.keySet()) {
                String field = (String)this.convertOnReadSingle(key, (TypeInformation<?>)ClassTypeInformation.from(String.class));
                builder.set(field, this.convertOnWrite(map.get(key), EmbeddedType.of(valueTypeInformation), field, valueTypeInformation));
            }
        });
    }

    private EntityValue convertOnWriteSingleEmbedded(Object val, String kindName) {
        return this.applyEntityValueBuilder(kindName, builder -> this.datastoreEntityConverter.write(val, builder));
    }

    @Override
    public Value convertOnWriteSingle(Object propertyVal) {
        Object result = propertyVal;
        if (result != null) {
            TypeTargets typeTargets = this.computeTypeTargets(result.getClass());
            if (typeTargets.getFirstStepTarget() != null) {
                result = this.conversionService.convert(propertyVal, typeTargets.getFirstStepTarget());
            }
            if (typeTargets.getSecondStepTarget() != null) {
                result = this.internalConversionService.convert(result, typeTargets.getSecondStepTarget());
            }
        }
        return DatastoreNativeTypes.wrapValue(result);
    }

    private TypeTargets computeTypeTargets(Class<?> firstStepSource) {
        Class firstStepTarget = null;
        Class<?> secondStepTarget = null;
        if (!DatastoreNativeTypes.isNativeType(firstStepSource)) {
            Class effectiveFirstStepTarget;
            Optional<Class<?>> datastoreBasicType;
            Optional simpleType = this.customConversions.getCustomWriteTarget(firstStepSource);
            if (simpleType.isPresent()) {
                firstStepTarget = (Class)simpleType.get();
            }
            if ((datastoreBasicType = this.getCustomWriteTarget(effectiveFirstStepTarget = firstStepTarget != null ? firstStepTarget : firstStepSource)).isPresent()) {
                secondStepTarget = datastoreBasicType.get();
            }
        }
        return new TypeTargets(firstStepTarget, secondStepTarget);
    }

    public <T> T convertCollection(Object collection, Class<?> target) {
        if (collection == null || target == null || ClassUtils.isAssignableValue(target, (Object)collection)) {
            return (T)collection;
        }
        return (T)this.conversionService.convert(collection, target);
    }

    private Optional<Class<?>> getCustomWriteTarget(Class<?> sourceType) {
        if (DatastoreNativeTypes.isNativeType(sourceType)) {
            return Optional.empty();
        }
        return this.writeConverters.computeIfAbsent(sourceType, this::getDatastoreCompatibleType);
    }

    @Override
    public Optional<Class<?>> getDatastoreCompatibleType(Class inputType) {
        if (DatastoreNativeTypes.DATASTORE_NATIVE_TYPES.contains(inputType)) {
            return Optional.of(inputType);
        }
        return DatastoreNativeTypes.DATASTORE_NATIVE_TYPES.stream().filter(simpleType -> this.internalConversionService.canConvert(inputType, simpleType) && this.internalConversionService.canConvert(simpleType, inputType)).findAny();
    }

    @Override
    public void registerEntityConverter(DatastoreEntityConverter datastoreEntityConverter) {
        this.datastoreEntityConverter = datastoreEntityConverter;
    }

    private static class TypeTargets {
        private Class<?> firstStepTarget;
        private Class<?> secondStepTarget;

        TypeTargets(Class<?> firstStepTarget, Class<?> secondStepTarget) {
            this.firstStepTarget = firstStepTarget;
            this.secondStepTarget = secondStepTarget;
        }

        Class<?> getFirstStepTarget() {
            return this.firstStepTarget;
        }

        Class<?> getSecondStepTarget() {
            return this.secondStepTarget;
        }
    }
}

