/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreReaderWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.PathElement;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Value;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreOperations;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreQueryOptions;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTransactionManager;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreEntityConverter;
import org.springframework.cloud.gcp.data.datastore.core.convert.ObjectToKeyFactory;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.core.util.ValueUtil;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.TypeUtils;

public class DatastoreTemplate
implements DatastoreOperations {
    private final DatastoreReaderWriter datastore;
    private final DatastoreEntityConverter datastoreEntityConverter;
    private final DatastoreMappingContext datastoreMappingContext;
    private final ObjectToKeyFactory objectToKeyFactory;

    public DatastoreTemplate(DatastoreReaderWriter datastore, DatastoreEntityConverter datastoreEntityConverter, DatastoreMappingContext datastoreMappingContext, ObjectToKeyFactory objectToKeyFactory) {
        Assert.notNull((Object)datastore, (String)"A non-null Datastore service object is required.");
        Assert.notNull((Object)datastoreEntityConverter, (String)"A non-null DatastoreEntityConverter is required.");
        Assert.notNull((Object)((Object)datastoreMappingContext), (String)"A non-null DatastoreMappingContext is required.");
        Assert.notNull((Object)objectToKeyFactory, (String)"A non-null Object to Key factory is required.");
        this.datastore = datastore;
        this.datastoreEntityConverter = datastoreEntityConverter;
        this.datastoreMappingContext = datastoreMappingContext;
        this.objectToKeyFactory = objectToKeyFactory;
    }

    public DatastoreEntityConverter getDatastoreEntityConverter() {
        return this.datastoreEntityConverter;
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Iterator results = this.findAllById(Collections.singleton(id), (Class)entityClass).iterator();
        return results.hasNext() ? (T)results.next() : null;
    }

    @Override
    public <T> T save(T instance, Key ... ancestors) {
        this.getDatastoreReadWriter().put((FullEntity)this.convertToEntityForSave(instance, ancestors));
        return instance;
    }

    @Override
    public <T> Iterable<T> saveAll(Iterable<T> entities, Key ... ancestors) {
        this.getDatastoreReadWriter().put((FullEntity[])StreamSupport.stream(entities.spliterator(), false).map(entity -> this.convertToEntityForSave(entity, ancestors)).toArray(Entity[]::new));
        return entities;
    }

    @Override
    public <T> void deleteById(Object id, Class<T> entityClass) {
        this.getDatastoreReadWriter().delete(new Key[]{this.getKeyFromId(id, entityClass)});
    }

    @Override
    public <T> void deleteAllById(Iterable<?> ids, Class<T> entityClass) {
        List<Key> keys = this.getKeysFromIds(ids, entityClass);
        this.getDatastoreReadWriter().delete(keys.toArray(new Key[keys.size()]));
    }

    @Override
    public <T> void delete(T entity) {
        this.getDatastoreReadWriter().delete(new Key[]{this.getKey(entity, false, new Key[0])});
    }

    @Override
    public <T> void deleteAll(Iterable<T> entities) {
        this.getDatastoreReadWriter().delete((Key[])StreamSupport.stream(entities.spliterator(), false).map(x -> this.getKey(x, false, new Key[0])).toArray(Key[]::new));
    }

    @Override
    public long deleteAll(Class<?> entityClass) {
        Key[] keysToDelete = this.findAllKeys(entityClass);
        this.getDatastoreReadWriter().delete(keysToDelete);
        return keysToDelete.length;
    }

    @Override
    public long count(Class<?> entityClass) {
        return this.findAllKeys(entityClass).length;
    }

    public <T> Collection<T> findAllById(Iterable<?> ids, Class<T> entityClass) {
        List<Key> keysToFind = this.getKeysFromIds(ids, entityClass);
        return this.convertEntitiesForRead(this.getDatastoreReadWriter().get(keysToFind.toArray(new Key[keysToFind.size()])), entityClass);
    }

    @Override
    public <T> Iterable<T> query(Query<? extends BaseEntity> query, Class<T> entityClass) {
        return this.convertEntitiesForRead((Iterator<? extends BaseEntity>)this.getDatastoreReadWriter().run(query), entityClass);
    }

    public <T> Iterable<?> queryKeysOrEntities(Query query, Class<T> entityClass) {
        QueryResults results = this.getDatastoreReadWriter().run(query);
        if (results.getResultClass() == Key.class) {
            return () -> results;
        }
        return this.convertEntitiesForRead((Iterator<? extends BaseEntity>)results, entityClass);
    }

    public <A, T> List<T> query(Query<A> query, Function<A, T> entityFunc) {
        ArrayList results = new ArrayList();
        this.getDatastoreReadWriter().run(query).forEachRemaining(x -> results.add(entityFunc.apply(x)));
        return results;
    }

    @Override
    public Iterable<Key> queryKeys(Query<Key> query) {
        return () -> this.getDatastoreReadWriter().run(query);
    }

    public <T> Collection<T> findAll(Class<T> entityClass) {
        return this.findAll(entityClass, null);
    }

    @Override
    public <T> Collection<T> findAll(Class<T> entityClass, DatastoreQueryOptions queryOptions) {
        DatastorePersistentEntity persistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass);
        EntityQuery.Builder builder = (EntityQuery.Builder)Query.newEntityQueryBuilder().setKind(persistentEntity.kindName());
        DatastoreTemplate.applyQueryOptions((StructuredQuery.Builder)builder, queryOptions, persistentEntity);
        return this.convertEntitiesForRead((Iterator<? extends BaseEntity>)this.getDatastoreReadWriter().run((Query)builder.build()), entityClass);
    }

    public static void applyQueryOptions(StructuredQuery.Builder builder, DatastoreQueryOptions queryOptions, DatastorePersistentEntity<?> persistentEntity) {
        if (queryOptions == null) {
            return;
        }
        if (queryOptions.getLimit() != null) {
            builder.setLimit(queryOptions.getLimit());
        }
        if (queryOptions.getOffset() != null) {
            builder.setOffset(queryOptions.getOffset().intValue());
        }
        if (queryOptions.getSort() != null && persistentEntity != null) {
            queryOptions.getSort().stream().map(order -> DatastoreTemplate.createOrderBy(persistentEntity, order)).forEachOrdered(orderBy -> builder.addOrderBy(orderBy, new StructuredQuery.OrderBy[0]));
        }
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> entityClass) {
        return this.findById(id, entityClass) != null;
    }

    @Override
    public <A> A performTransaction(Function<DatastoreOperations, A> operations) {
        if (!(this.getDatastoreReadWriter() instanceof Datastore)) {
            throw new DatastoreDataException("This DatastoreReadWriter cannot be used to run transactions. A full Datastore service object is required to run functions as transactions. Ensure that this method was not called in an ongoing transaction.");
        }
        return (A)((Datastore)this.getDatastoreReadWriter()).runInTransaction(readerWriter -> operations.apply(new DatastoreTemplate(readerWriter, this.datastoreEntityConverter, this.datastoreMappingContext, this.objectToKeyFactory)));
    }

    @Override
    public <T> Map<String, T> findByIdAsMap(Key key, Class<T> valueType) {
        Assert.notNull((Object)key, (String)"A non-null Key is required.");
        Assert.notNull(valueType, (String)"A non-null valueType is required.");
        Entity entity = this.getDatastoreReadWriter().get(key);
        return this.datastoreEntityConverter.readAsMap(String.class, ClassTypeInformation.from(valueType), (BaseEntity)entity);
    }

    @Override
    public <V> void writeMap(Key datastoreKey, Map<String, V> map) {
        Assert.notNull((Object)datastoreKey, (String)"A non-null Key is required.");
        Assert.notNull(map, (String)"A non-null map is required.");
        Entity.Builder builder = Entity.newBuilder((Key)datastoreKey);
        map.forEach((key, value) -> {
            Entity.Builder cfr_ignored_0 = (Entity.Builder)builder.set(key, this.datastoreEntityConverter.getConversions().convertOnWriteSingle(value));
        });
        Entity entity = builder.build();
        this.getDatastoreReadWriter().put((FullEntity)entity);
    }

    @Override
    public Key createKey(String kind, Object id) {
        return this.objectToKeyFactory.getKeyFromId(id, kind);
    }

    private static StructuredQuery.OrderBy createOrderBy(DatastorePersistentEntity<?> persistentEntity, Sort.Order order) {
        if (order.isIgnoreCase()) {
            throw new DatastoreDataException("Datastore doesn't support sorting ignoring case");
        }
        if (!order.getNullHandling().equals((Object)Sort.NullHandling.NATIVE)) {
            throw new DatastoreDataException("Datastore supports only NullHandling.NATIVE null handling");
        }
        return new StructuredQuery.OrderBy(((DatastorePersistentProperty)persistentEntity.getPersistentProperty(order.getProperty())).getFieldName(), order.getDirection() == Sort.Direction.DESC ? StructuredQuery.OrderBy.Direction.DESCENDING : StructuredQuery.OrderBy.Direction.ASCENDING);
    }

    private Entity convertToEntityForSave(Object entity, Key ... ancestors) {
        if (ancestors != null) {
            for (Key ancestor : ancestors) {
                this.validateKey(entity, DatastoreTemplate.keyToPathElement(ancestor));
            }
        }
        Key key = this.getKey(entity, true, ancestors);
        Entity.Builder builder = Entity.newBuilder((Key)key);
        this.datastoreEntityConverter.write(entity, builder);
        this.saveDescendents(entity, key);
        this.saveReferences(entity, builder);
        return builder.build();
    }

    private void saveReferences(Object entity, Entity.Builder builder) {
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entity.getClass());
        datastorePersistentEntity.doWithReferenceProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)persistentProperty -> {
            KeyValue value;
            PersistentPropertyAccessor accessor = datastorePersistentEntity.getPropertyAccessor(entity);
            Object val = accessor.getProperty(persistentProperty);
            if (val == null) {
                return;
            }
            if (persistentProperty.isCollectionLike()) {
                Iterable iterableVal = (Iterable)ValueUtil.toListIfArray(val);
                this.saveAll(iterableVal, new Key[0]);
                List keyValues = StreamSupport.stream(iterableVal.spliterator(), false).map(o -> KeyValue.of((Key)this.getKey(o, false, new Key[0]))).collect(Collectors.toList());
                value = ListValue.of(keyValues);
            } else {
                this.save(val, new Key[0]);
                Key key = this.getKey(val, false, new Key[0]);
                value = KeyValue.of((Key)key);
            }
            builder.set(((DatastorePersistentProperty)persistentProperty).getFieldName(), (Value)value);
        }));
    }

    private void saveDescendents(Object entity, Key key) {
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entity.getClass());
        datastorePersistentEntity.doWithDescendantProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)persistentProperty -> {
            PersistentPropertyAccessor accessor = datastorePersistentEntity.getPropertyAccessor(entity);
            Object val = accessor.getProperty(persistentProperty);
            if (val != null) {
                this.saveAll((Iterable)ValueUtil.toListIfArray(val), key);
            }
        }));
    }

    public static PathElement keyToPathElement(Key key) {
        Assert.notNull((Object)key, (String)"A non-null key is required");
        return key.getName() != null ? PathElement.of((String)key.getKind(), (String)key.getName()) : PathElement.of((String)key.getKind(), (long)key.getId());
    }

    private void validateKey(Object entity, PathElement ancestorPE) {
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entity.getClass());
        DatastorePersistentProperty idProp = datastorePersistentEntity.getIdPropertyOrFail();
        if (!TypeUtils.isAssignable(BaseKey.class, (Type)idProp.getType())) {
            throw new DatastoreDataException("Only Key types are allowed for descendants id");
        }
        Key key = this.getKey(entity, false, new Key[0]);
        if (key == null || key.getAncestors().stream().anyMatch(pe -> pe.equals((Object)ancestorPE))) {
            return;
        }
        throw new DatastoreDataException("Descendant object has a key without current ancestor");
    }

    public <T> List<T> convertEntitiesForRead(Iterator<? extends BaseEntity> entities, Class<T> entityClass) {
        ArrayList results = new ArrayList();
        if (entities == null) {
            return results;
        }
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass);
        entities.forEachRemaining(entity -> this.convertEntityResolveDescendantsAndReferences(entityClass, results, datastorePersistentEntity, (BaseEntity)entity));
        return results;
    }

    private <T> void convertEntityResolveDescendantsAndReferences(Class<T> entityClass, List<T> results, DatastorePersistentEntity datastorePersistentEntity, BaseEntity entity) {
        Object convertedObject = this.datastoreEntityConverter.read(entityClass, entity);
        results.add(convertedObject);
        this.resolveDescendantProperties(datastorePersistentEntity, entity, convertedObject);
        this.resolveReferenceProperties(datastorePersistentEntity, entity, convertedObject);
    }

    private <T> void resolveReferenceProperties(DatastorePersistentEntity datastorePersistentEntity, BaseEntity entity, T convertedObject) {
        datastorePersistentEntity.doWithReferenceProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)referencePersistentProperty -> {
            Object referenced = this.findReferenced(entity, (DatastorePersistentProperty)referencePersistentProperty);
            if (referenced != null) {
                datastorePersistentEntity.getPropertyAccessor(convertedObject).setProperty(referencePersistentProperty, referenced);
            }
        }));
    }

    private Object findReferenced(BaseEntity entity, DatastorePersistentProperty referencePersistentProperty) {
        String fieldName = referencePersistentProperty.getFieldName();
        try {
            Object referenced;
            if (!entity.contains(fieldName)) {
                referenced = null;
            } else if (referencePersistentProperty.isCollectionLike()) {
                Class referencedType = referencePersistentProperty.getComponentType();
                List keyValues = entity.getList(fieldName);
                referenced = this.datastoreEntityConverter.getConversions().convertOnRead((Object)this.findAllById((Iterable)keyValues.stream().map(Value::get).collect(Collectors.toList()), referencedType), referencePersistentProperty.getType(), referencedType);
            } else {
                referenced = this.findById(entity.getKey(fieldName), referencePersistentProperty.getType());
            }
            return referenced;
        }
        catch (ClassCastException ex) {
            throw new DatastoreDataException("Error loading reference property " + fieldName + ".Reference properties must be stored as Keys or lists of Keys in Cloud Datastore for singular or multiple references, respectively.");
        }
    }

    private <T> void resolveDescendantProperties(DatastorePersistentEntity datastorePersistentEntity, BaseEntity entity, T convertedObject) {
        datastorePersistentEntity.doWithDescendantProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)descendantPersistentProperty -> {
            Class descendantType = descendantPersistentProperty.getComponentType();
            EntityQuery descendantQuery = ((EntityQuery.Builder)((EntityQuery.Builder)Query.newEntityQueryBuilder().setKind(((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(descendantType)).kindName())).setFilter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.hasAncestor((Key)((Key)entity.getKey())))).build();
            datastorePersistentEntity.getPropertyAccessor(convertedObject).setProperty(descendantPersistentProperty, this.datastoreEntityConverter.getConversions().convertOnRead(this.convertEntitiesForRead((Iterator<? extends BaseEntity>)this.getDatastoreReadWriter().run((Query)descendantQuery), descendantType), descendantPersistentProperty.getType(), descendantType));
        }));
    }

    private Key getKeyFromId(Object id, Class entityClass) {
        return this.objectToKeyFactory.getKeyFromId(id, ((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass)).kindName());
    }

    private Key getKey(Object entity, boolean allocateKey, Key ... ancestors) {
        DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entity.getClass());
        DatastorePersistentProperty idProp = datastorePersistentEntity.getIdPropertyOrFail();
        if (datastorePersistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProp) == null && allocateKey) {
            return this.objectToKeyFactory.allocateKeyForObject(entity, datastorePersistentEntity, ancestors);
        }
        return this.objectToKeyFactory.getKeyFromObject(entity, datastorePersistentEntity);
    }

    private Key[] findAllKeys(Class entityClass) {
        Iterable<Key> keysFound = this.queryKeys((Query<Key>)((KeyQuery.Builder)Query.newKeyQueryBuilder().setKind(((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass)).kindName())).build());
        return (Key[])StreamSupport.stream(keysFound.spliterator(), false).toArray(Key[]::new);
    }

    private <T> List<Key> getKeysFromIds(Iterable<?> ids, Class<T> entityClass) {
        ArrayList<Key> keys = new ArrayList<Key>();
        ids.forEach(x -> keys.add(this.getKeyFromId(x, entityClass)));
        return keys;
    }

    private DatastoreReaderWriter getDatastoreReadWriter() {
        return TransactionSynchronizationManager.isActualTransactionActive() ? ((DatastoreTransactionManager.Tx)((DefaultTransactionStatus)TransactionAspectSupport.currentTransactionStatus()).getTransaction()).getTransaction() : this.datastore;
    }
}

