/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.SpannerOptions;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.spanner.GcpSpannerAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.spanner.GcpSpannerProperties;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={GcpSpannerAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpSpannerProperties.class})
@ConditionalOnProperty(prefix="spring.cloud.gcp.spanner.emulator", name={"enabled"}, havingValue="true")
public class GcpSpannerEmulatorAutoConfiguration {
    private final GcpSpannerProperties properties;
    private final String projectId;

    public GcpSpannerEmulatorAutoConfiguration(GcpSpannerProperties properties, GcpProjectIdProvider projectIdProvider) {
        this.projectId = properties.getProjectId() != null ? properties.getProjectId() : projectIdProvider.getProjectId();
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerOptions spannerOptions() {
        Assert.notNull((Object)this.properties.getEmulatorHost(), (String)"`spring.cloud.gcp.spanner.emulator-host` must be set.");
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(this.projectId)).setCredentials((Credentials)NoCredentials.getInstance())).setEmulatorHost(this.properties.getEmulatorHost()).build();
    }
}

