/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.spanner;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.gcp.core.Credentials;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.GcpScope;

@ConfigurationProperties(value="spring.cloud.gcp.spanner")
public class GcpSpannerProperties
implements CredentialsSupplier {
    @NestedConfigurationProperty
    private final Credentials credentials = new Credentials(new String[]{GcpScope.SPANNER_DATA.getUrl(), GcpScope.SPANNER_ADMIN.getUrl()});
    private String projectId;
    private String instanceId;
    private String database;
    private boolean createInterleavedTableDdlOnDeleteCascade = true;
    private int numRpcChannels = -1;
    private int prefetchChunks = -1;
    private int minSessions = -1;
    private int maxSessions = -1;
    private int maxIdleSessions = -1;
    private float writeSessionsFraction = -1.0f;
    private int keepAliveIntervalMinutes = -1;
    private boolean failIfPoolExhausted = false;

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int getNumRpcChannels() {
        return this.numRpcChannels;
    }

    public void setNumRpcChannels(int numRpcChannels) {
        this.numRpcChannels = numRpcChannels;
    }

    public int getPrefetchChunks() {
        return this.prefetchChunks;
    }

    public void setPrefetchChunks(int prefetchChunks) {
        this.prefetchChunks = prefetchChunks;
    }

    public int getMinSessions() {
        return this.minSessions;
    }

    public void setMinSessions(int minSessions) {
        this.minSessions = minSessions;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public int getMaxIdleSessions() {
        return this.maxIdleSessions;
    }

    public void setMaxIdleSessions(int maxIdleSessions) {
        this.maxIdleSessions = maxIdleSessions;
    }

    public float getWriteSessionsFraction() {
        return this.writeSessionsFraction;
    }

    public void setWriteSessionsFraction(float writeSessionsFraction) {
        this.writeSessionsFraction = writeSessionsFraction;
    }

    public int getKeepAliveIntervalMinutes() {
        return this.keepAliveIntervalMinutes;
    }

    public void setKeepAliveIntervalMinutes(int keepAliveIntervalMinutes) {
        this.keepAliveIntervalMinutes = keepAliveIntervalMinutes;
    }

    public boolean isCreateInterleavedTableDdlOnDeleteCascade() {
        return this.createInterleavedTableDdlOnDeleteCascade;
    }

    public void setCreateInterleavedTableDdlOnDeleteCascade(boolean createInterleavedTableDdlOnDeleteCascade) {
        this.createInterleavedTableDdlOnDeleteCascade = createInterleavedTableDdlOnDeleteCascade;
    }

    public boolean isFailIfPoolExhausted() {
        return this.failIfPoolExhausted;
    }

    public void setFailIfPoolExhausted(boolean failIfPoolExhausted) {
        this.failIfPoolExhausted = failIfPoolExhausted;
    }
}

