/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.pubsub;

import com.google.api.core.ApiClock;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.pubsub.GcpPubSubProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.cloud.gcp.pubsub.PubSubAdmin;
import org.springframework.cloud.gcp.pubsub.core.PubSubException;
import org.springframework.cloud.gcp.pubsub.core.PubSubTemplate;
import org.springframework.cloud.gcp.pubsub.core.publisher.PubSubPublisherTemplate;
import org.springframework.cloud.gcp.pubsub.core.subscriber.PubSubSubscriberTemplate;
import org.springframework.cloud.gcp.pubsub.support.DefaultPublisherFactory;
import org.springframework.cloud.gcp.pubsub.support.DefaultSubscriberFactory;
import org.springframework.cloud.gcp.pubsub.support.PublisherFactory;
import org.springframework.cloud.gcp.pubsub.support.SubscriberFactory;
import org.springframework.cloud.gcp.pubsub.support.converter.PubSubMessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.threeten.bp.Duration;

@Configuration
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.pubsub.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={PubSubTemplate.class})
@EnableConfigurationProperties(value={GcpPubSubProperties.class})
public class GcpPubSubAutoConfiguration {
    private final GcpPubSubProperties gcpPubSubProperties;
    private final GcpProjectIdProvider finalProjectIdProvider;
    private final CredentialsProvider finalCredentialsProvider;
    private final HeaderProvider headerProvider = new UserAgentHeaderProvider(this.getClass());

    public GcpPubSubAutoConfiguration(GcpPubSubProperties gcpPubSubProperties, GcpProjectIdProvider gcpProjectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.gcpPubSubProperties = gcpPubSubProperties;
        GcpProjectIdProvider gcpProjectIdProvider2 = gcpPubSubProperties.getProjectId() != null ? gcpPubSubProperties::getProjectId : (this.finalProjectIdProvider = gcpProjectIdProvider);
        this.finalCredentialsProvider = gcpPubSubProperties.getEmulatorHost() == null || "false".equals(gcpPubSubProperties.getEmulatorHost()) ? (gcpPubSubProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpPubSubProperties) : credentialsProvider) : NoCredentialsProvider.create();
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubsubPublisherThreadPool"})
    public ThreadPoolTaskScheduler pubsubPublisherThreadPool() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(this.gcpPubSubProperties.getPublisher().getExecutorThreads());
        scheduler.setThreadNamePrefix("gcp-pubsub-publisher");
        scheduler.setDaemon(true);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherExecutorProvider"})
    public ExecutorProvider publisherExecutorProvider(@Qualifier(value="pubsubPublisherThreadPool") ThreadPoolTaskScheduler scheduler) {
        return FixedExecutorProvider.create((ScheduledExecutorService)scheduler.getScheduledExecutor());
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubsubSubscriberThreadPool"})
    public ThreadPoolTaskScheduler pubsubSubscriberThreadPool() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(this.gcpPubSubProperties.getSubscriber().getExecutorThreads());
        scheduler.setThreadNamePrefix("gcp-pubsub-subscriber");
        scheduler.setDaemon(true);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberExecutorProvider"})
    public ExecutorProvider subscriberExecutorProvider(@Qualifier(value="pubsubSubscriberThreadPool") ThreadPoolTaskScheduler scheduler) {
        return FixedExecutorProvider.create((ScheduledExecutorService)scheduler.getScheduledExecutor());
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubPublisherTemplate pubSubPublisherTemplate(PublisherFactory publisherFactory, ObjectProvider<PubSubMessageConverter> pubSubMessageConverter) {
        PubSubPublisherTemplate pubSubPublisherTemplate = new PubSubPublisherTemplate(publisherFactory);
        pubSubMessageConverter.ifUnique(arg_0 -> ((PubSubPublisherTemplate)pubSubPublisherTemplate).setMessageConverter(arg_0));
        return pubSubPublisherTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubSubAcknowledgementExecutor"})
    public Executor pubSubAcknowledgementExecutor() {
        ThreadPoolTaskExecutor ackExecutor = new ThreadPoolTaskExecutor();
        ackExecutor.setMaxPoolSize(this.gcpPubSubProperties.getSubscriber().getMaxAcknowledgementThreads());
        ackExecutor.setThreadNamePrefix("gcp-pubsub-ack-executor");
        ackExecutor.setDaemon(true);
        return ackExecutor;
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubSubscriberTemplate pubSubSubscriberTemplate(SubscriberFactory subscriberFactory, ObjectProvider<PubSubMessageConverter> pubSubMessageConverter, @Qualifier(value="pubSubAcknowledgementExecutor") Executor executor) {
        PubSubSubscriberTemplate pubSubSubscriberTemplate = new PubSubSubscriberTemplate(subscriberFactory);
        pubSubMessageConverter.ifUnique(arg_0 -> ((PubSubSubscriberTemplate)pubSubSubscriberTemplate).setMessageConverter(arg_0));
        pubSubSubscriberTemplate.setAckExecutor(executor);
        return pubSubSubscriberTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubTemplate pubSubTemplate(PubSubPublisherTemplate pubSubPublisherTemplate, PubSubSubscriberTemplate pubSubSubscriberTemplate) {
        return new PubSubTemplate(pubSubPublisherTemplate, pubSubSubscriberTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberRetrySettings"})
    public RetrySettings subscriberRetrySettings() {
        return this.buildRetrySettings(this.gcpPubSubProperties.getSubscriber().getRetry());
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberFlowControlSettings"})
    public FlowControlSettings subscriberFlowControlSettings() {
        return this.buildFlowControlSettings(this.gcpPubSubProperties.getSubscriber().getFlowControl());
    }

    private FlowControlSettings buildFlowControlSettings(GcpPubSubProperties.FlowControl flowControl) {
        FlowControlSettings.Builder builder = FlowControlSettings.newBuilder();
        return this.ifNotNull(flowControl.getLimitExceededBehavior(), arg_0 -> ((FlowControlSettings.Builder)builder).setLimitExceededBehavior(arg_0)).apply(this.ifNotNull(flowControl.getMaxOutstandingElementCount(), arg_0 -> ((FlowControlSettings.Builder)builder).setMaxOutstandingElementCount(arg_0)).apply(this.ifNotNull(flowControl.getMaxOutstandingRequestBytes(), arg_0 -> ((FlowControlSettings.Builder)builder).setMaxOutstandingRequestBytes(arg_0)).apply(false))) != false ? builder.build() : null;
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberFactory defaultSubscriberFactory(@Qualifier(value="subscriberExecutorProvider") ExecutorProvider executorProvider, @Qualifier(value="subscriberSystemExecutorProvider") ObjectProvider<ExecutorProvider> systemExecutorProvider, @Qualifier(value="subscriberFlowControlSettings") ObjectProvider<FlowControlSettings> flowControlSettings, @Qualifier(value="subscriberApiClock") ObjectProvider<ApiClock> apiClock, @Qualifier(value="subscriberRetrySettings") ObjectProvider<RetrySettings> retrySettings, TransportChannelProvider transportChannelProvider) {
        DefaultSubscriberFactory factory = new DefaultSubscriberFactory(this.finalProjectIdProvider);
        factory.setExecutorProvider(executorProvider);
        factory.setCredentialsProvider(this.finalCredentialsProvider);
        factory.setHeaderProvider(this.headerProvider);
        factory.setChannelProvider(transportChannelProvider);
        systemExecutorProvider.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setSystemExecutorProvider(arg_0));
        flowControlSettings.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setFlowControlSettings(arg_0));
        apiClock.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setApiClock(arg_0));
        retrySettings.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setSubscriberStubRetrySettings(arg_0));
        if (this.gcpPubSubProperties.getSubscriber().getMaxAckExtensionPeriod() != null) {
            factory.setMaxAckExtensionPeriod(Duration.ofSeconds((long)this.gcpPubSubProperties.getSubscriber().getMaxAckExtensionPeriod()));
        }
        if (this.gcpPubSubProperties.getSubscriber().getParallelPullCount() != null) {
            factory.setParallelPullCount(this.gcpPubSubProperties.getSubscriber().getParallelPullCount());
        }
        if (this.gcpPubSubProperties.getSubscriber().getPullEndpoint() != null) {
            factory.setPullEndpoint(this.gcpPubSubProperties.getSubscriber().getPullEndpoint());
        }
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherBatchSettings"})
    public BatchingSettings publisherBatchSettings() {
        BatchingSettings.Builder builder = BatchingSettings.newBuilder();
        GcpPubSubProperties.Batching batching = this.gcpPubSubProperties.getPublisher().getBatching();
        FlowControlSettings flowControlSettings = this.buildFlowControlSettings(batching.getFlowControl());
        if (flowControlSettings != null) {
            builder.setFlowControlSettings(flowControlSettings);
        }
        return this.ifNotNull(batching.getDelayThresholdSeconds(), x -> builder.setDelayThreshold(Duration.ofSeconds((long)x))).apply(this.ifNotNull(batching.getElementCountThreshold(), arg_0 -> ((BatchingSettings.Builder)builder).setElementCountThreshold(arg_0)).apply(this.ifNotNull(batching.getEnabled(), arg_0 -> ((BatchingSettings.Builder)builder).setIsEnabled(arg_0)).apply(this.ifNotNull(batching.getRequestByteThreshold(), arg_0 -> ((BatchingSettings.Builder)builder).setRequestByteThreshold(arg_0)).apply(false)))) != false ? builder.build() : null;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherRetrySettings"})
    public RetrySettings publisherRetrySettings() {
        return this.buildRetrySettings(this.gcpPubSubProperties.getPublisher().getRetry());
    }

    private RetrySettings buildRetrySettings(GcpPubSubProperties.Retry retryProperties) {
        RetrySettings.Builder builder = RetrySettings.newBuilder();
        return this.ifNotNull(retryProperties.getInitialRetryDelaySeconds(), x -> builder.setInitialRetryDelay(Duration.ofSeconds((long)x))).apply(this.ifNotNull(retryProperties.getInitialRpcTimeoutSeconds(), x -> builder.setInitialRpcTimeout(Duration.ofSeconds((long)x))).apply(this.ifNotNull(retryProperties.getJittered(), arg_0 -> ((RetrySettings.Builder)builder).setJittered(arg_0)).apply(this.ifNotNull(retryProperties.getMaxAttempts(), arg_0 -> ((RetrySettings.Builder)builder).setMaxAttempts(arg_0)).apply(this.ifNotNull(retryProperties.getMaxRetryDelaySeconds(), x -> builder.setMaxRetryDelay(Duration.ofSeconds((long)x))).apply(this.ifNotNull(retryProperties.getMaxRpcTimeoutSeconds(), x -> builder.setMaxRpcTimeout(Duration.ofSeconds((long)x))).apply(this.ifNotNull(retryProperties.getRetryDelayMultiplier(), arg_0 -> ((RetrySettings.Builder)builder).setRetryDelayMultiplier(arg_0)).apply(this.ifNotNull(retryProperties.getTotalTimeoutSeconds(), x -> builder.setTotalTimeout(Duration.ofSeconds((long)x))).apply(this.ifNotNull(retryProperties.getRpcTimeoutMultiplier(), arg_0 -> ((RetrySettings.Builder)builder).setRpcTimeoutMultiplier(arg_0)).apply(false))))))))) != false ? builder.build() : null;
    }

    private <T> Function<Boolean, Boolean> ifNotNull(T prop, Consumer<T> consumer) {
        return next -> {
            boolean wasSet = next;
            if (prop != null) {
                consumer.accept(prop);
                wasSet = true;
            }
            return wasSet;
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public PublisherFactory defaultPublisherFactory(@Qualifier(value="publisherExecutorProvider") ExecutorProvider executorProvider, @Qualifier(value="publisherBatchSettings") ObjectProvider<BatchingSettings> batchingSettings, @Qualifier(value="publisherRetrySettings") ObjectProvider<RetrySettings> retrySettings, TransportChannelProvider transportChannelProvider) {
        DefaultPublisherFactory factory = new DefaultPublisherFactory(this.finalProjectIdProvider);
        factory.setExecutorProvider(executorProvider);
        factory.setCredentialsProvider(this.finalCredentialsProvider);
        factory.setHeaderProvider(this.headerProvider);
        factory.setChannelProvider(transportChannelProvider);
        retrySettings.ifAvailable(arg_0 -> ((DefaultPublisherFactory)factory).setRetrySettings(arg_0));
        batchingSettings.ifAvailable(arg_0 -> ((DefaultPublisherFactory)factory).setBatchingSettings(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubAdmin pubSubAdmin(TopicAdminClient topicAdminClient, SubscriptionAdminClient subscriptionAdminClient) {
        return new PubSubAdmin(this.finalProjectIdProvider, topicAdminClient, subscriptionAdminClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public TopicAdminClient topicAdminClient(TopicAdminSettings topicAdminSettings) {
        try {
            return TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating TopicAdminClient.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public TopicAdminSettings topicAdminSettings(TransportChannelProvider transportChannelProvider) {
        try {
            return ((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.finalCredentialsProvider)).setHeaderProvider(this.headerProvider)).setTransportChannelProvider(transportChannelProvider)).build();
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating TopicAdminSettings.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriptionAdminClient subscriptionAdminClient(TransportChannelProvider transportChannelProvider) {
        try {
            return SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.finalCredentialsProvider)).setHeaderProvider(this.headerProvider)).setTransportChannelProvider(transportChannelProvider)).build());
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating SubscriptionAdminClient.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public TransportChannelProvider transportChannelProvider() {
        return InstantiatingGrpcChannelProvider.newBuilder().setKeepAliveTime(Duration.ofMinutes((long)this.gcpPubSubProperties.getKeepAliveIntervalMinutes())).build();
    }
}

