/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.core;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class AppEngineCondition
extends SpringBootCondition {
    public static final String APPENGINE_RUNTIME_PROPERTY = "com.google.appengine.runtime.version";
    public static final String APPENGINE_RUNTIME_PREFIX = "Google App Engine/";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String appEngineVersion = System.getProperty(APPENGINE_RUNTIME_PROPERTY);
        boolean match = !StringUtils.isEmpty((Object)appEngineVersion) && appEngineVersion.startsWith(APPENGINE_RUNTIME_PREFIX);
        String message = match ? "Your app is running on Google App Engine. com.google.appengine.runtime.version property is set to " + appEngineVersion + "." : "App not running on Google App Engine. Property com.google.appengine.runtime.version isn't present, or it doesn't start with the Google App Engine/ prefix.";
        return new ConditionOutcome(match, message);
    }
}

