/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.spanner;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.spanner.GcpSpannerProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UsageTrackingHeaderProvider;
import org.springframework.cloud.gcp.data.spanner.core.SpannerMutationFactory;
import org.springframework.cloud.gcp.data.spanner.core.SpannerMutationFactoryImpl;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.admin.SpannerSchemaUtils;
import org.springframework.cloud.gcp.data.spanner.core.convert.MappingSpannerConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerConverter;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.spanner.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={SpannerMappingContext.class, SpannerOperations.class, SpannerMutationFactory.class, SpannerConverter.class})
@EnableConfigurationProperties(value={GcpSpannerProperties.class})
public class GcpSpannerAutoConfiguration {
    private final String projectId;
    private final String instanceId;
    private final String databaseName;
    private final Credentials credentials;

    public GcpSpannerAutoConfiguration(GcpSpannerProperties gcpSpannerProperties, GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.credentials = (gcpSpannerProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpSpannerProperties) : credentialsProvider).getCredentials();
        this.projectId = gcpSpannerProperties.getProjectId() != null ? gcpSpannerProperties.getProjectId() : projectIdProvider.getProjectId();
        this.instanceId = gcpSpannerProperties.getInstanceId();
        this.databaseName = gcpSpannerProperties.getDatabase();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerOptions spannerOptions() {
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(this.projectId)).setHeaderProvider((HeaderProvider)new UsageTrackingHeaderProvider(this.getClass()))).setCredentials(this.credentials)).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public DatabaseId databaseId() {
        return DatabaseId.of((String)this.projectId, (String)this.instanceId, (String)this.databaseName);
    }

    @Bean
    @ConditionalOnMissingBean
    public Spanner spanner(SpannerOptions spannerOptions) {
        return (Spanner)spannerOptions.getService();
    }

    @Bean
    @ConditionalOnMissingBean
    public DatabaseClient spannerDatabaseClient(Spanner spanner, DatabaseId databaseId) {
        return spanner.getDatabaseClient(databaseId);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerMappingContext spannerMappingContext() {
        return new SpannerMappingContext();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerTemplate spannerTemplate(DatabaseClient databaseClient, SpannerMappingContext mappingContext, SpannerConverter spannerConverter, SpannerMutationFactory spannerMutationFactory) {
        return new SpannerTemplate(databaseClient, mappingContext, spannerConverter, spannerMutationFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerConverter spannerConverter(SpannerMappingContext mappingContext) {
        return new MappingSpannerConverter(mappingContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerMutationFactory spannerMutationFactory(SpannerConverter spannerConverter, SpannerMappingContext spannerMappingContext) {
        return new SpannerMutationFactoryImpl(spannerConverter, spannerMappingContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerSchemaUtils spannerSchemaUtils(SpannerMappingContext spannerMappingContext, SpannerConverter spannerConverter) {
        return new SpannerSchemaUtils(spannerMappingContext);
    }
}

