/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.pubsub.GcpPubSubProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UsageTrackingHeaderProvider;
import org.springframework.cloud.gcp.pubsub.PubSubAdmin;
import org.springframework.cloud.gcp.pubsub.core.PubSubException;
import org.springframework.cloud.gcp.pubsub.core.PubSubTemplate;
import org.springframework.cloud.gcp.pubsub.support.DefaultPublisherFactory;
import org.springframework.cloud.gcp.pubsub.support.DefaultSubscriberFactory;
import org.springframework.cloud.gcp.pubsub.support.PublisherFactory;
import org.springframework.cloud.gcp.pubsub.support.SubscriberFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.pubsub.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={PubSubTemplate.class})
@EnableConfigurationProperties(value={GcpPubSubProperties.class})
public class GcpPubSubAutoConfiguration {
    private final GcpPubSubProperties gcpPubSubProperties;
    private final GcpProjectIdProvider finalProjectIdProvider;
    private final CredentialsProvider finalCredentialsProvider;
    private final HeaderProvider headerProvider = new UsageTrackingHeaderProvider(this.getClass());

    public GcpPubSubAutoConfiguration(GcpPubSubProperties gcpPubSubProperties, GcpProjectIdProvider gcpProjectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.gcpPubSubProperties = gcpPubSubProperties;
        this.finalProjectIdProvider = gcpPubSubProperties.getProjectId() != null ? gcpPubSubProperties::getProjectId : gcpProjectIdProvider;
        this.finalCredentialsProvider = gcpPubSubProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpPubSubProperties) : credentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherExecutorProvider"})
    public ExecutorProvider publisherExecutorProvider() {
        return FixedExecutorProvider.create((ScheduledExecutorService)Executors.newScheduledThreadPool(this.gcpPubSubProperties.getPublisherExecutorThreads()));
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberExecutorProvider"})
    public ExecutorProvider subscriberExecutorProvider() {
        return FixedExecutorProvider.create((ScheduledExecutorService)Executors.newScheduledThreadPool(this.gcpPubSubProperties.getSubscriberExecutorThreads()));
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubTemplate pubSubTemplate(PublisherFactory publisherFactory, SubscriberFactory subscriberFactory) {
        return new PubSubTemplate(publisherFactory, subscriberFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberFactory defaultSubscriberFactory(@Qualifier(value="subscriberExecutorProvider") ExecutorProvider executorProvider, TransportChannelProvider transportChannelProvider) {
        DefaultSubscriberFactory factory = new DefaultSubscriberFactory(this.finalProjectIdProvider);
        factory.setExecutorProvider(executorProvider);
        factory.setCredentialsProvider(this.finalCredentialsProvider);
        factory.setHeaderProvider(this.headerProvider);
        factory.setChannelProvider(transportChannelProvider);
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    public PublisherFactory defaultPublisherFactory(@Qualifier(value="publisherExecutorProvider") ExecutorProvider executorProvider, TransportChannelProvider transportChannelProvider) {
        DefaultPublisherFactory factory = new DefaultPublisherFactory(this.finalProjectIdProvider);
        factory.setExecutorProvider(executorProvider);
        factory.setCredentialsProvider(this.finalCredentialsProvider);
        factory.setHeaderProvider(this.headerProvider);
        factory.setChannelProvider(transportChannelProvider);
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubAdmin pubSubAdmin(TopicAdminClient topicAdminClient, SubscriptionAdminClient subscriptionAdminClient) {
        return new PubSubAdmin(this.finalProjectIdProvider, topicAdminClient, subscriptionAdminClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public TopicAdminClient topicAdminClient(TransportChannelProvider transportChannelProvider) {
        try {
            return TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.finalCredentialsProvider)).setHeaderProvider(this.headerProvider)).setTransportChannelProvider(transportChannelProvider)).build());
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating TopicAdminClient.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriptionAdminClient subscriptionAdminClient(TransportChannelProvider transportChannelProvider) {
        try {
            return SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.finalCredentialsProvider)).setHeaderProvider(this.headerProvider)).setTransportChannelProvider(transportChannelProvider)).build());
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating SubscriptionAdminClient.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public TransportChannelProvider transportChannelProvider() {
        return InstantiatingGrpcChannelProvider.newBuilder().build();
    }
}

