/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.logging;

import com.google.cloud.logging.TraceLoggingEnhancer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.gcp.autoconfigure.logging.TraceIdExtractor;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TraceIdLoggingWebMvcInterceptor
extends HandlerInterceptorAdapter {
    private final TraceIdExtractor traceIdExtractor;

    public TraceIdLoggingWebMvcInterceptor(TraceIdExtractor extractor) {
        Assert.notNull((Object)extractor, (String)"A valid trace id extractor is required.");
        this.traceIdExtractor = extractor;
    }

    public TraceIdExtractor getTraceIdExtractor() {
        return this.traceIdExtractor;
    }

    public boolean preHandle(HttpServletRequest req, HttpServletResponse resp, Object handler) throws Exception {
        String traceId = this.traceIdExtractor.extractTraceIdFromRequest(req);
        if (traceId != null) {
            TraceLoggingEnhancer.setCurrentTraceId((String)traceId);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Exception e) throws Exception {
        TraceLoggingEnhancer.setCurrentTraceId(null);
    }
}

