/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.logging;

import com.google.cloud.logging.TraceLoggingEnhancer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.logging.CompositeTraceIdExtractor;
import org.springframework.cloud.gcp.autoconfigure.logging.LoggingWebMvcConfigurer;
import org.springframework.cloud.gcp.autoconfigure.logging.StackdriverLoggingProperties;
import org.springframework.cloud.gcp.autoconfigure.logging.TraceIdExtractor;
import org.springframework.cloud.gcp.autoconfigure.logging.TraceIdExtractorType;
import org.springframework.cloud.gcp.autoconfigure.logging.TraceIdLoggingWebMvcInterceptor;
import org.springframework.cloud.gcp.autoconfigure.logging.XCloudTraceIdExtractor;
import org.springframework.cloud.gcp.autoconfigure.logging.ZipkinTraceIdExtractor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={TraceLoggingEnhancer.class})
@EnableConfigurationProperties(value={StackdriverLoggingProperties.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.logging.enabled"}, matchIfMissing=true)
@Import(value={LoggingWebMvcConfigurer.class})
public class StackdriverLoggingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TraceIdLoggingWebMvcInterceptor loggingWebMvcInterceptor(TraceIdExtractor extractor) {
        return new TraceIdLoggingWebMvcInterceptor(extractor);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceIdExtractor traceIdExtractor(StackdriverLoggingProperties loggingProperties) {
        TraceIdExtractor extractor;
        TraceIdExtractorType checkedType = loggingProperties.getTraceIdExtractor();
        if (checkedType == null) {
            checkedType = TraceIdExtractorType.XCLOUD_ZIPKIN;
        }
        switch (checkedType) {
            case XCLOUD: {
                extractor = new XCloudTraceIdExtractor();
                break;
            }
            case ZIPKIN: {
                extractor = new ZipkinTraceIdExtractor();
                break;
            }
            case ZIPKIN_XCLOUD: {
                extractor = new CompositeTraceIdExtractor(new ZipkinTraceIdExtractor(), new XCloudTraceIdExtractor());
                break;
            }
            case XCLOUD_ZIPKIN: {
                extractor = new CompositeTraceIdExtractor(new XCloudTraceIdExtractor(), new ZipkinTraceIdExtractor());
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)checkedType) + " is not a valid trace ID extractor type.");
            }
        }
        return extractor;
    }
}

