/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import com.google.cloud.logging.TraceLoggingEnhancer;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

public class StackdriverJsonLayout
extends JsonLayout {
    public static final String SEVERITY_ATTRIBUTE = "severity";
    public static final String TIMESTAMP_SECONDS_ATTRIBUTE = "timestampSeconds";
    public static final String TIMESTAMP_NANOS_ATTRIBUTE = "timestampNanos";
    public static final String SPAN_ID_ATTRIBUTE = "logging.googleapis.com/spanId";
    public static final String TRACE_ID_ATTRIBUTE = "logging.googleapis.com/trace";
    public static final String MDC_FIELD_TRACE_ID = "X-B3-TraceId";
    public static final String MDC_FIELD_SPAN_ID = "X-B3-SpanId";
    public static final String MDC_FIELD_SPAN_EXPORT = "X-Span-Export";
    private static final Set<String> FILTERED_MDC_FIELDS = new HashSet<String>(Arrays.asList("X-B3-TraceId", "X-B3-SpanId", "X-Span-Export"));
    private String projectId;
    private boolean includeTraceId;
    private boolean includeSpanId;
    private boolean includeExceptionInMessage;

    public StackdriverJsonLayout() {
        this.appendLineSeparator = true;
        this.includeExceptionInMessage = true;
        this.includeException = false;
        this.includeTraceId = true;
        this.includeSpanId = true;
        Gson formatter = new Gson();
        this.setJsonFormatter(arg_0 -> ((Gson)formatter).toJson(arg_0));
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean isIncludeTraceId() {
        return this.includeTraceId;
    }

    public void setIncludeTraceId(boolean includeTraceId) {
        this.includeTraceId = includeTraceId;
    }

    public boolean isIncludeSpanId() {
        return this.includeSpanId;
    }

    public void setIncludeSpanId(boolean includeSpanId) {
        this.includeSpanId = includeSpanId;
    }

    public boolean isIncludeExceptionInMessage() {
        return this.includeExceptionInMessage;
    }

    public void setIncludeExceptionInMessage(boolean includeExceptionInMessage) {
        this.includeExceptionInMessage = includeExceptionInMessage;
    }

    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.includeMDC) {
            event.getMDCPropertyMap().forEach((key, value) -> {
                if (FILTERED_MDC_FIELDS.contains(key)) {
                    return;
                }
                map.put((String)key, value);
            });
        }
        if (this.includeTimestamp) {
            map.put(TIMESTAMP_SECONDS_ATTRIBUTE, TimeUnit.MILLISECONDS.toSeconds(event.getTimeStamp()));
            map.put(TIMESTAMP_NANOS_ATTRIBUTE, TimeUnit.MILLISECONDS.toNanos(event.getTimeStamp() % 1000L));
        }
        this.add(SEVERITY_ATTRIBUTE, this.includeLevel, String.valueOf(event.getLevel()), map);
        this.add("thread", this.includeThreadName, event.getThreadName(), map);
        this.add("logger", this.includeLoggerName, event.getLoggerName(), map);
        if (this.includeFormattedMessage) {
            String stackTrace;
            IThrowableProxy throwableProxy;
            String message = event.getFormattedMessage();
            if (this.includeExceptionInMessage && (throwableProxy = event.getThrowableProxy()) != null && (stackTrace = this.getThrowableProxyConverter().convert((Object)event)) != null && !stackTrace.equals("")) {
                message = message + "\n" + stackTrace;
            }
            map.put("message", message);
        }
        this.add("raw-message", this.includeMessage, event.getMessage(), map);
        this.add("context", this.includeContextName, event.getLoggerContextVO().getName(), map);
        this.addThrowableInfo("exception", this.includeException, event, map);
        this.addTraceId(event, map);
        this.add(SPAN_ID_ATTRIBUTE, this.includeSpanId, (String)event.getMDCPropertyMap().get(MDC_FIELD_SPAN_ID), map);
        this.addCustomDataToJsonMap(map, event);
        return map;
    }

    private void addTraceId(ILoggingEvent event, Map<String, Object> map) {
        if (!this.includeTraceId) {
            return;
        }
        String traceId = TraceLoggingEnhancer.getCurrentTraceId();
        if (traceId == null) {
            traceId = (String)event.getMDCPropertyMap().get(MDC_FIELD_TRACE_ID);
        }
        if (!(StringUtils.isEmpty((Object)traceId) || StringUtils.isEmpty((Object)this.projectId) || this.projectId.endsWith("_IS_UNDEFINED"))) {
            traceId = "projects/" + this.projectId + "/traces/" + traceId;
        }
        this.add(TRACE_ID_ATTRIBUTE, this.includeTraceId, traceId, map);
    }
}

