/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.logging;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.gcp.autoconfigure.logging.TraceIdExtractor;
import org.springframework.util.Assert;

public class CompositeTraceIdExtractor
implements TraceIdExtractor {
    private final List<TraceIdExtractor> extractors;

    public CompositeTraceIdExtractor(TraceIdExtractor ... extractors) {
        Assert.notEmpty((Object[])extractors, (String)"A list of valid trace ID extractors is required.");
        this.extractors = ImmutableList.copyOf((Object[])extractors);
    }

    public List<TraceIdExtractor> getExtractors() {
        return this.extractors;
    }

    @Override
    public String extractTraceIdFromRequest(HttpServletRequest req) {
        for (TraceIdExtractor extractor : this.getExtractors()) {
            String traceId = extractor.extractTraceIdFromRequest(req);
            if (traceId == null) continue;
            return traceId;
        }
        return null;
    }
}

