/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.core.cloudfoundry;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class GcpCloudFoundryEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final String VCAP_SERVICES_ENVVAR = "VCAP_SERVICES";
    private static final Log LOGGER = LogFactory.getLog(GcpCloudFoundryEnvironmentPostProcessor.class);
    private static final String SPRING_CLOUD_GCP_PROPERTY_PREFIX = "spring.cloud.gcp.";
    private JsonParser parser = JsonParserFactory.getJsonParser();
    private int order = -2147483639;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!StringUtils.isEmpty((Object)environment.getProperty(VCAP_SERVICES_ENVVAR))) {
            Map vcapMap = this.parser.parseMap(environment.getProperty(VCAP_SERVICES_ENVVAR));
            Properties gcpCfServiceProperties = new Properties();
            for (GcpCfService cfService : GcpCfService.values()) {
                gcpCfServiceProperties.putAll((Map<?, ?>)GcpCloudFoundryEnvironmentPostProcessor.retrieveCfProperties(vcapMap, cfService));
            }
            environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("gcpCf", gcpCfServiceProperties));
        }
    }

    private static Properties retrieveCfProperties(Map<String, Object> vcapMap, GcpCfService service) {
        Properties properties = new Properties();
        List serviceBindings = (List)vcapMap.get(service.getCfServiceName());
        if (serviceBindings == null) {
            return properties;
        }
        if (serviceBindings.size() != 1) {
            LOGGER.warn((Object)("The service " + service.getCfServiceName() + " has to be bound to a Cloud Foundry application once and only once."));
            return properties;
        }
        Map serviceBinding = (Map)serviceBindings.get(0);
        Map credentialsMap = (Map)serviceBinding.get("credentials");
        String prefix = SPRING_CLOUD_GCP_PROPERTY_PREFIX + service.name() + ".";
        service.getCfPropNameToGcp().forEach((cfPropKey, gcpPropKey) -> properties.put(prefix + gcpPropKey, credentialsMap.get(cfPropKey)));
        return properties;
    }

    public int getOrder() {
        return this.order;
    }

    private static enum GcpCfService {
        pubsub("google-pubsub", (Map<String, String>)ImmutableMap.of((Object)"ProjectId", (Object)"project-id", (Object)"PrivateKeyData", (Object)"credentials.encoded-key")),
        storage("google-storage", (Map<String, String>)ImmutableMap.of((Object)"ProjectId", (Object)"project-id", (Object)"PrivateKeyData", (Object)"credentials.encoded-key")),
        spanner("google-spanner", (Map<String, String>)ImmutableMap.of((Object)"ProjectId", (Object)"project-id", (Object)"PrivateKeyData", (Object)"credentials.encoded-key", (Object)"instance_id", (Object)"instance-id")),
        trace("google-stackdriver-trace", (Map<String, String>)ImmutableMap.of((Object)"ProjectId", (Object)"project-id", (Object)"PrivateKeyData", (Object)"credentials.encoded-key"));

        private String cfServiceName;
        private Map<String, String> cfPropNameToGcp;

        private GcpCfService(String cfServiceName, Map<String, String> cfPropNameToGcp) {
            this.cfServiceName = cfServiceName;
            this.cfPropNameToGcp = cfPropNameToGcp;
        }

        public String getCfServiceName() {
            return this.cfServiceName;
        }

        public Map<String, String> getCfPropNameToGcp() {
            return this.cfPropNameToGcp;
        }
    }
}

