/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.time.Duration;
import org.springframework.cache.Cache;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManagerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GlobalLocalResponseCacheGatewayFilter
implements GlobalFilter,
Ordered {
    private final ResponseCacheGatewayFilter responseCacheGatewayFilter;

    public GlobalLocalResponseCacheGatewayFilter(ResponseCacheManagerFactory cacheManagerFactory, Cache globalCache, Duration configuredTimeToLive) {
        this.responseCacheGatewayFilter = new ResponseCacheGatewayFilter(cacheManagerFactory.create(globalCache, configuredTimeToLive));
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (exchange.getAttributes().get("LocalResponseCacheGatewayFilter-Applied") == null) {
            return this.responseCacheGatewayFilter.filter(exchange, chain);
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -3;
    }
}

