/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke;

import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public interface OperationArgumentResolver {
    public boolean canResolve(Class<?> var1);

    public <T> @Nullable T resolve(Class<T> var1);

    public static <T> OperationArgumentResolver of(final Class<T> type, final Supplier<? extends T> supplier) {
        Objects.requireNonNull(type, "Type must not be null");
        Objects.requireNonNull(supplier, "Supplier must not be null");
        return new OperationArgumentResolver(){

            @Override
            public boolean canResolve(Class<?> actualType) {
                return actualType.equals(type);
            }

            public <R> R resolve(Class<R> argumentType) {
                return (R)supplier.get();
            }
        };
    }
}

