/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.MediaType;

@ConfigurationProperties(value="spring.cloud.gateway.server.webmvc")
public class GatewayMvcProperties {
    public static final String PREFIX = "spring.cloud.gateway.server.webmvc";
    @NotNull
    @Valid
    private List<RouteProperties> routes = new ArrayList<RouteProperties>();
    @NotNull
    @Valid
    private LinkedHashMap<String, RouteProperties> routesMap = new LinkedHashMap();
    private List<MediaType> streamingMediaTypes = Arrays.asList(MediaType.TEXT_EVENT_STREAM, new MediaType("application", "stream+json"), new MediaType("application", "grpc"), new MediaType("application", "grpc+protobuf"), new MediaType("application", "grpc+json"));
    private int streamingBufferSize = 16384;
    private @Nullable String trustedProxies;
    private boolean useFrameworkRetryFilter = false;

    public List<RouteProperties> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteProperties> routes) {
        this.routes = routes;
    }

    public LinkedHashMap<String, RouteProperties> getRoutesMap() {
        return this.routesMap;
    }

    public void setRoutesMap(LinkedHashMap<String, RouteProperties> routesMap) {
        this.routesMap = routesMap;
    }

    public List<MediaType> getStreamingMediaTypes() {
        return this.streamingMediaTypes;
    }

    public void setStreamingMediaTypes(List<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes = streamingMediaTypes;
    }

    public boolean isUseFrameworkRetryFilter() {
        return this.useFrameworkRetryFilter;
    }

    public void setUseFrameworkRetryFilter(boolean useFrameworkRetryFilter) {
        this.useFrameworkRetryFilter = useFrameworkRetryFilter;
    }

    public int getStreamingBufferSize() {
        return this.streamingBufferSize;
    }

    public void setStreamingBufferSize(int streamingBufferSize) {
        this.streamingBufferSize = streamingBufferSize;
    }

    public @Nullable String getTrustedProxies() {
        return this.trustedProxies;
    }

    public void setTrustedProxies(String trustedProxies) {
        this.trustedProxies = trustedProxies;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("routes", this.routes).append("routesMap", this.routesMap).append("streamingMediaTypes", this.streamingMediaTypes).append("streamingBufferSize", this.streamingBufferSize).append("trustedProxies", (Object)this.trustedProxies).toString();
    }
}

