/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayErrorHandlingServerResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.async.AsyncWebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.AsyncServerResponse;
import org.springframework.web.servlet.function.ServerResponse;

final class GatewayAsyncServerResponse
extends GatewayErrorHandlingServerResponse
implements AsyncServerResponse {
    static final boolean reactiveStreamsPresent = ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)GatewayAsyncServerResponse.class.getClassLoader());
    private final CompletableFuture<ServerResponse> futureResponse;
    private final @Nullable Duration timeout;

    private GatewayAsyncServerResponse(CompletableFuture<ServerResponse> futureResponse, @Nullable Duration timeout) {
        this.futureResponse = futureResponse;
        this.timeout = timeout;
    }

    public ServerResponse block() {
        try {
            if (this.timeout != null) {
                return this.futureResponse.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            return this.futureResponse.get();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new IllegalStateException("Failed to get future response", ex);
        }
    }

    public HttpStatusCode statusCode() {
        return this.delegate(ServerResponse::statusCode);
    }

    public HttpHeaders headers() {
        return this.delegate(ServerResponse::headers);
    }

    public MultiValueMap<String, Cookie> cookies() {
        return this.delegate(ServerResponse::cookies);
    }

    private <R> R delegate(Function<ServerResponse, R> function) {
        ServerResponse response = this.futureResponse.getNow(null);
        if (response != null) {
            return function.apply(response);
        }
        throw new IllegalStateException("Future ServerResponse has not yet completed");
    }

    public @Nullable ModelAndView writeTo(HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) throws ServletException, IOException {
        GatewayAsyncServerResponse.writeAsync(request, response, this.createDeferredResult(request));
        return null;
    }

    static void writeAsync(HttpServletRequest request, HttpServletResponse response, DeferredResult<?> deferredResult) throws ServletException, IOException {
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)request);
        AsyncWebRequest asyncWebRequest = WebAsyncUtils.createAsyncWebRequest((HttpServletRequest)request, (HttpServletResponse)response);
        asyncManager.setAsyncWebRequest(asyncWebRequest);
        try {
            asyncManager.startDeferredResultProcessing(deferredResult, new Object[0]);
        }
        catch (ServletException | IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServletException("Async processing failed", (Throwable)ex);
        }
    }

    private DeferredResult<ServerResponse> createDeferredResult(HttpServletRequest request) {
        DeferredResult result = this.timeout != null ? new DeferredResult(Long.valueOf(this.timeout.toMillis())) : new DeferredResult();
        this.futureResponse.whenComplete((value, ex) -> {
            if (ex != null) {
                ServerResponse errorResponse;
                if (ex instanceof CompletionException && ex.getCause() != null) {
                    ex = ex.getCause();
                }
                if ((errorResponse = this.errorResponse((Throwable)ex, request)) != null) {
                    result.setResult((Object)errorResponse);
                } else {
                    result.setErrorResult(ex);
                }
            } else {
                result.setResult(value);
            }
        });
        return result;
    }

    public static AsyncServerResponse create(Object obj, @Nullable Duration timeout) {
        Assert.notNull((Object)obj, (String)"Argument to async must not be null");
        if (obj instanceof CompletableFuture) {
            CompletableFuture futureResponse = (CompletableFuture)obj;
            return new GatewayAsyncServerResponse(futureResponse, timeout);
        }
        throw new IllegalArgumentException("Asynchronous type not supported: " + String.valueOf(obj.getClass()));
    }
}

