/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import io.github.bucket4j.BucketConfiguration;
import java.util.Collections;
import java.util.function.Function;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcProperties;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.cloud.gateway.server.mvc.filter.Bucket4jFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.CircuitBreakerFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.FilterBeanFactoryDiscoverer;
import org.springframework.cloud.gateway.server.mvc.filter.FilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.LoadBalancerFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.RetryFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.TokenRelayFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerFunctionDefinition;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerFunctions;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;

@AutoConfiguration
public class FilterAutoConfiguration {
    @Bean
    public FilterBeanFactoryDiscoverer filterBeanFactoryDiscoverer(BeanFactory beanFactory) {
        return new FilterBeanFactoryDiscoverer(beanFactory);
    }

    @Bean
    public FilterFunctions.FilterSupplier filterFunctionsSupplier() {
        return new FilterFunctions.FilterSupplier();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OAuth2AuthorizedClient.class})
    static class TokenRelayFilterConfiguration {
        TokenRelayFilterConfiguration() {
        }

        @Bean
        public TokenRelayFilterFunctions.FilterSupplier tokenRelayFilterFunctionsSupplier() {
            return new TokenRelayFilterFunctions.FilterSupplier();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class RetryFilterConfiguration {
        private final GatewayMvcProperties properties;

        RetryFilterConfiguration(GatewayMvcProperties properties) {
            this.properties = properties;
        }

        @Bean
        public RetryFilterFunctions.FilterSupplier retryFilterFunctionsSupplier() {
            RetryFilterFunctions.setUseFrameworkRetry(this.properties.isUseFrameworkRetryFilter());
            return new RetryFilterFunctions.FilterSupplier();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={LoadBalancerClient.class})
    public static class LoadBalancerHandlerConfiguration {
        @Bean
        public Function<RouteProperties, HandlerFunctionDefinition> lbHandlerFunctionDefinition() {
            return routeProperties -> new HandlerFunctionDefinition.Default("lb", HandlerFunctions.http(), Collections.emptyList(), Collections.singletonList(LoadBalancerFilterFunctions.lb(routeProperties.getUri().getHost())));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CircuitBreaker.class})
    static class CircuitBreakerFilterConfiguration {
        CircuitBreakerFilterConfiguration() {
        }

        @Bean
        public CircuitBreakerFilterFunctions.FilterSupplier circuitBreakerFilterFunctionsSupplier() {
            return new CircuitBreakerFilterFunctions.FilterSupplier();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={BucketConfiguration.class})
    static class Bucket4jFilterConfiguration {
        Bucket4jFilterConfiguration() {
        }

        @Bean
        public Bucket4jFilterFunctions.FilterSupplier bucket4jFilterFunctionsSupplier() {
            return new Bucket4jFilterFunctions.FilterSupplier();
        }
    }
}

