/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke.reflect;

import java.lang.reflect.Method;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameters;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.OperationMethod;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.OperationMethodParameters;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;

public class DefaultOperationMethod
implements OperationMethod {
    private static final ParameterNameDiscoverer DEFAULT_PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Method method;
    private final OperationParameters operationParameters;

    public DefaultOperationMethod(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        this.method = method;
        this.operationParameters = new OperationMethodParameters(method, DEFAULT_PARAMETER_NAME_DISCOVERER);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public OperationParameters getParameters() {
        return this.operationParameters;
    }

    public String toString() {
        return "Operation method " + String.valueOf(this.method);
    }
}

