/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface TrustedProxies {
    public boolean isTrusted(String var1);

    public static TrustedProxies from(@NonNull String trustedProxies) {
        Assert.hasText((String)trustedProxies, (String)"trustedProxies must not be empty");
        Pattern pattern = Pattern.compile(trustedProxies);
        return value -> pattern.matcher(value).matches();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Documented
    @Conditional(value={OnPropertyExistsCondition.class})
    public static @interface ConditionalOnPropertyExists {
        public String value();
    }

    public static class OnPropertyExistsCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            try {
                String value = metadata.getAnnotations().get(ConditionalOnPropertyExists.class).getString("value");
                String property = context.getEnvironment().getProperty(value);
                if (!StringUtils.hasText((String)property)) {
                    return ConditionOutcome.noMatch((String)(value + " property is not set or is empty."));
                }
                return ConditionOutcome.match((String)(value + " property is not empty."));
            }
            catch (NoSuchElementException e) {
                return ConditionOutcome.noMatch((String)"Missing required property 'value' of @ConditionalOnPropertyExists");
            }
        }
    }

    public static class XForwardedTrustedProxiesCondition
    extends AllNestedConditions {
        public XForwardedTrustedProxiesCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnPropertyExists(value="spring.cloud.gateway.server.webmvc.trusted-proxies")
        static class OnTrustedProxiesNotEmpty {
            OnTrustedProxiesNotEmpty() {
            }
        }

        @ConditionalOnProperty(name={"spring.cloud.gateway.server.webmvc.x-forwarded-request-headers-filter.enabled"}, matchIfMissing=true)
        static class OnPropertyEnabled {
            OnPropertyEnabled() {
            }
        }
    }

    public static class ForwardedTrustedProxiesCondition
    extends AllNestedConditions {
        public ForwardedTrustedProxiesCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnPropertyExists(value="spring.cloud.gateway.server.webmvc.trusted-proxies")
        static class OnTrustedProxiesNotEmpty {
            OnTrustedProxiesNotEmpty() {
            }
        }

        @ConditionalOnProperty(name={"spring.cloud.gateway.server.webmvc.forwarded-request-headers-filter.enabled"}, matchIfMissing=true)
        static class OnPropertyEnabled {
            OnPropertyEnabled() {
            }
        }
    }
}

