/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RewriteResponseHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String REGEXP_KEY = "regexp";
    public static final String REPLACEMENT_KEY = "replacement";

    public RewriteResponseHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", REGEXP_KEY, REPLACEMENT_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){
            final /* synthetic */ RewriteResponseHeaderGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return chain.filter(exchange).then(Mono.fromRunnable(() -> this.this$0.rewriteHeaders(exchange, config)));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append("name", (Object)config.getName()).append(RewriteResponseHeaderGatewayFilterFactory.REGEXP_KEY, (Object)config.getRegexp()).append(RewriteResponseHeaderGatewayFilterFactory.REPLACEMENT_KEY, (Object)config.getReplacement()).toString();
            }
        };
    }

    protected void rewriteHeaders(ServerWebExchange exchange, Config config) {
        String name = Objects.requireNonNull(config.getName(), "name must not be null");
        HttpHeaders responseHeaders = exchange.getResponse().getHeaders();
        if (responseHeaders.get(name) != null) {
            List oldValue = Objects.requireNonNull(responseHeaders.get(name), "oldValue must not be null");
            List<String> newValue = this.rewriteHeaders(config, oldValue);
            if (newValue != null) {
                responseHeaders.put(name, newValue);
            } else {
                responseHeaders.remove(name);
            }
        }
    }

    protected List<String> rewriteHeaders(Config config, List<String> headers) {
        String regexp = Objects.requireNonNull(config.getRegexp(), "regexp must not be null");
        String replacement = Objects.requireNonNull(config.getReplacement(), "replacement must not be null");
        ArrayList<String> rewrittenHeaders = new ArrayList<String>();
        for (int i = 0; i < headers.size(); ++i) {
            String rewriten = this.rewrite(headers.get(i), regexp, replacement);
            rewrittenHeaders.add(rewriten);
        }
        return rewrittenHeaders;
    }

    String rewrite(String value, String regexp, String replacement) {
        return value.replaceAll(regexp, replacement.replace("$\\", "$"));
    }

    public static class Config
    extends AbstractGatewayFilterFactory.NameConfig {
        private @Nullable String regexp;
        private @Nullable String replacement;

        public @Nullable String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }

        public @Nullable String getReplacement() {
            return this.replacement;
        }

        public Config setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }
    }
}

