/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.event.EnableBodyCachingEvent;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.support.AbstractConfigurable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public abstract class AbstractGatewayFilterFactory<C>
extends AbstractConfigurable<C>
implements GatewayFilterFactory<C>,
ApplicationEventPublisherAware {
    private @Nullable ApplicationEventPublisher publisher;

    public AbstractGatewayFilterFactory() {
        super(Object.class);
    }

    public AbstractGatewayFilterFactory(Class<C> configClass) {
        super(configClass);
    }

    protected @Nullable ApplicationEventPublisher getPublisher() {
        return this.publisher;
    }

    protected void enableBodyCaching(@Nullable String routeId) {
        if (routeId != null && this.getPublisher() != null) {
            this.getPublisher().publishEvent((ApplicationEvent)new EnableBodyCachingEvent(this, routeId));
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public static class NameConfig {
        private @Nullable String name;

        public @Nullable String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

