/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.factory.SetStatusGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class StreamRoutingFilter
implements GlobalFilter,
Ordered {
    private final StreamBridge streamBridge;
    private final List<HttpMessageReader<?>> messageReaders;
    private final SetStatusGatewayFilterFactory setStatusFilter;

    public StreamRoutingFilter(StreamBridge streamBridge, List<HttpMessageReader<?>> messageReaders) {
        this.streamBridge = streamBridge;
        this.messageReaders = messageReaders;
        this.streamBridge.setAsync(true);
        this.setStatusFilter = new SetStatusGatewayFilterFactory();
    }

    public int getOrder() {
        return 10010;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange) || !"stream".equals(scheme)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange);
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
        return serverRequest.bodyToMono(byte[].class).flatMap(requestBody -> {
            ServerHttpRequest request = exchange.getRequest();
            HttpHeaders headers = request.getHeaders();
            Message inputMessage = null;
            MessageBuilder builder = MessageBuilder.withPayload((Object)requestBody);
            if (!CollectionUtils.isEmpty((Map)request.getQueryParams())) {
                builder = builder.setHeader("http_request_param", (Object)request.getQueryParams().toSingleValueMap());
            }
            inputMessage = builder.copyHeaders(headers.toSingleValueMap()).build();
            boolean send = this.streamBridge.send(requestUrl.getHost(), (Object)inputMessage);
            HttpStatus responseStatus = send ? HttpStatus.OK : HttpStatus.BAD_REQUEST;
            SetStatusGatewayFilterFactory.Config config = new SetStatusGatewayFilterFactory.Config();
            config.setStatus(responseStatus.name());
            return this.setStatusFilter.apply(config).filter(exchange, chain);
        });
    }
}

