/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.IdGenerator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CompositeRouteDefinitionLocator
implements RouteDefinitionLocator {
    private static final Log log = LogFactory.getLog(CompositeRouteDefinitionLocator.class);
    private final Flux<RouteDefinitionLocator> delegates;
    private final IdGenerator idGenerator;

    public CompositeRouteDefinitionLocator(Flux<RouteDefinitionLocator> delegates) {
        this(delegates, (IdGenerator)new AlternativeJdkIdGenerator());
    }

    public CompositeRouteDefinitionLocator(Flux<RouteDefinitionLocator> delegates, IdGenerator idGenerator) {
        this.delegates = delegates;
        this.idGenerator = idGenerator;
    }

    @Override
    public Flux<RouteDefinition> getRouteDefinitions() {
        return this.delegates.flatMapSequential(RouteDefinitionLocator::getRouteDefinitions).flatMap(routeDefinition -> {
            if (routeDefinition.getId() == null) {
                return this.randomId().map(id -> {
                    routeDefinition.setId((String)id);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Id set on route definition: " + String.valueOf(routeDefinition)));
                    }
                    return routeDefinition;
                });
            }
            return Mono.just((Object)routeDefinition);
        });
    }

    protected Mono<String> randomId() {
        return Mono.fromSupplier(() -> ((IdGenerator)this.idGenerator).generateId()).publishOn(Schedulers.boundedElastic()).map(UUID::toString);
    }
}

