/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.handler.FilteringWebHandler;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RoutePredicateHandlerMapping
extends AbstractHandlerMapping {
    private final FilteringWebHandler webHandler;
    private final RouteLocator routeLocator;
    private final Integer managementPort;
    private final ManagementPortType managementPortType;

    public RoutePredicateHandlerMapping(FilteringWebHandler webHandler, RouteLocator routeLocator, GlobalCorsProperties globalCorsProperties, Environment environment) {
        this.webHandler = webHandler;
        this.routeLocator = routeLocator;
        this.managementPort = RoutePredicateHandlerMapping.getPortProperty(environment, "management.server.");
        this.managementPortType = this.getManagementPortType(environment);
        this.setOrder((Integer)environment.getProperty("spring.cloud.gateway.server.webflux.handler-mapping.order", Integer.class, (Object)1));
        this.setCorsConfigurations(globalCorsProperties.getCorsConfigurations());
    }

    private ManagementPortType getManagementPortType(Environment environment) {
        Integer serverPort = RoutePredicateHandlerMapping.getPortProperty(environment, "server.");
        if (this.managementPort != null && this.managementPort < 0) {
            return ManagementPortType.DISABLED;
        }
        return this.managementPort == null || serverPort == null && this.managementPort.equals(8080) || this.managementPort != 0 && this.managementPort.equals(serverPort) ? ManagementPortType.SAME : ManagementPortType.DIFFERENT;
    }

    private static Integer getPortProperty(Environment environment, String prefix) {
        return (Integer)environment.getProperty(prefix + "port", Integer.class);
    }

    protected Mono<?> getHandlerInternal(ServerWebExchange exchange) {
        if (this.managementPortType == ManagementPortType.DIFFERENT && this.managementPort != null && exchange.getRequest().getLocalAddress() != null && exchange.getRequest().getLocalAddress().getPort() == this.managementPort.intValue()) {
            return Mono.empty();
        }
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_HANDLER_MAPPER_ATTR, this.getSimpleName());
        return Mono.deferContextual(contextView -> {
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REACTOR_CONTEXT_ATTR, contextView);
            return this.lookupRoute(exchange).map(r -> {
                exchange.getAttributes().remove(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Mapping [" + this.getExchangeDesc(exchange) + "] to " + String.valueOf(r)));
                }
                exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, r);
                return this.webHandler;
            }).switchIfEmpty(Mono.empty().then(Mono.fromRunnable(() -> {
                exchange.getAttributes().remove(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
                ServerWebExchangeUtils.clearCachedRequestBody(exchange);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No RouteDefinition found for [" + this.getExchangeDesc(exchange) + "]"));
                }
            })));
        });
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange) {
        return super.getCorsConfiguration(handler, exchange);
    }

    private String getExchangeDesc(ServerWebExchange exchange) {
        StringBuilder out = new StringBuilder();
        out.append("Exchange: ");
        out.append(exchange.getRequest().getMethod());
        out.append(" ");
        out.append(exchange.getRequest().getURI());
        return out.toString();
    }

    protected Mono<Route> lookupRoute(ServerWebExchange exchange) {
        return this.routeLocator.getRoutes().filterWhen(route -> {
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR, route.getId());
            try {
                return (Publisher)route.getPredicate().apply(exchange);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error applying predicate for route: " + route.getId()), (Throwable)e);
                return Mono.just((Object)false);
            }
        }).next().map(route -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Route matched: " + route.getId()));
            }
            this.validateRoute((Route)route, exchange);
            return route;
        });
    }

    protected void validateRoute(Route route, ServerWebExchange exchange) {
    }

    protected String getSimpleName() {
        return "RoutePredicateHandlerMapping";
    }

    public static enum ManagementPortType {
        DISABLED,
        SAME,
        DIFFERENT;

    }
}

