/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.cert.X509Certificate;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.cloud.gateway.config.AbstractSslConfigurer;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

public class HttpClientSslConfigurer
extends AbstractSslConfigurer<HttpClient, HttpClient> {
    private final ServerProperties serverProperties;

    public HttpClientSslConfigurer(HttpClientProperties.Ssl sslProperties, ServerProperties serverProperties, SslBundles bundles) {
        super(sslProperties, bundles);
        this.serverProperties = serverProperties;
    }

    @Override
    public HttpClient configureSsl(HttpClient client) {
        HttpClientProperties.Ssl ssl = this.getSslProperties();
        if (this.getBundle() != null || ssl.getKeyStore() != null && ssl.getKeyStore().length() > 0 || this.getTrustedX509CertificatesForTrustManager().length > 0 || ssl.isUseInsecureTrustManager()) {
            client = client.secure(sslContextSpec -> this.configureSslContext(ssl, (SslProvider.SslContextSpec)sslContextSpec));
        }
        return client;
    }

    protected void configureSslContext(HttpClientProperties.Ssl ssl, SslProvider.SslContextSpec sslContextSpec) {
        Http2SslContextSpec clientSslContext = this.serverProperties.getHttp2().isEnabled() ? Http2SslContextSpec.forClient() : Http11SslContextSpec.forClient();
        clientSslContext.configure(sslContextBuilder -> {
            X509Certificate[] trustedX509Certificates = this.getTrustedX509CertificatesForTrustManager();
            SslBundle bundle = this.getBundle();
            if (trustedX509Certificates.length > 0) {
                this.setTrustManager((SslContextBuilder)sslContextBuilder, trustedX509Certificates);
            } else if (ssl.isUseInsecureTrustManager()) {
                this.setTrustManager((SslContextBuilder)sslContextBuilder, InsecureTrustManagerFactory.INSTANCE);
            } else if (bundle != null) {
                this.setTrustManager((SslContextBuilder)sslContextBuilder, bundle.getManagers().getTrustManagerFactory());
            }
            try {
                if (bundle != null) {
                    sslContextBuilder.keyManager(bundle.getManagers().getKeyManagerFactory());
                } else {
                    sslContextBuilder.keyManager(this.getKeyManagerFactory());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        });
        sslContextSpec.sslContext((SslProvider.ProtocolSslContextSpec)clientSslContext).handshakeTimeout(ssl.getHandshakeTimeout()).closeNotifyFlushTimeout(ssl.getCloseNotifyFlushTimeout()).closeNotifyReadTimeout(ssl.getCloseNotifyReadTimeout());
    }
}

