/*
 * Copyright 2013-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.gateway.support.tagsprovider;

import java.util.Map;
import java.util.stream.Collectors;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;

import org.springframework.web.server.ServerWebExchange;

/**
 * @author Ingyu Hwang
 */
public class PropertiesTagsProvider implements GatewayTagsProvider {

	private final Tags propertiesTags;

	public PropertiesTagsProvider(Map<String, String> tagsMap) {
		this.propertiesTags = Tags.of(tagsMap.entrySet()
			.stream()
			.map(entry -> Tag.of(entry.getKey(), entry.getValue()))
			.collect(Collectors.toList()));
	}

	@Override
	public Tags apply(ServerWebExchange serverWebExchange) {
		return propertiesTags;
	}

}
