/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.TrustedProxies;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.ServerRequest;

public class ForwardedRequestHeadersFilter
implements HttpHeadersFilter.RequestHttpHeadersFilter,
Ordered {
    private static final Log log = LogFactory.getLog(ForwardedRequestHeadersFilter.class);
    public static final String FORWARDED_HEADER = "Forwarded";
    private final TrustedProxies trustedProxies;

    @Deprecated
    public ForwardedRequestHeadersFilter() {
        this.trustedProxies = s -> true;
        log.warn((Object)"spring.cloud.gateway.server.webmvc.trusted-proxies is not set. Using deprecated Constructor. Untrusted hosts might be added to Forwarded header.");
    }

    public ForwardedRequestHeadersFilter(String trustedProxiesRegex) {
        this.trustedProxies = TrustedProxies.from(trustedProxiesRegex);
    }

    static List<Forwarded> parse(List<String> values) {
        ArrayList<Forwarded> forwardeds = new ArrayList<Forwarded>();
        if (CollectionUtils.isEmpty(values)) {
            return forwardeds;
        }
        for (String value : values) {
            String[] forwardedValues;
            for (String forwardedValue : forwardedValues = StringUtils.tokenizeToStringArray((String)value, (String)",")) {
                Forwarded forwarded = ForwardedRequestHeadersFilter.parse(forwardedValue);
                forwardeds.add(forwarded);
            }
        }
        return forwardeds;
    }

    static Forwarded parse(String value) {
        String[] pairs = StringUtils.tokenizeToStringArray((String)value, (String)";");
        LinkedCaseInsensitiveMap<String> result = ForwardedRequestHeadersFilter.splitIntoCaseInsensitiveMap(pairs);
        if (result == null) {
            return null;
        }
        Forwarded forwarded = new Forwarded((Map<String, String>)result);
        return forwarded;
    }

    static LinkedCaseInsensitiveMap<String> splitIntoCaseInsensitiveMap(String[] pairs) {
        if (ObjectUtils.isEmpty((Object[])pairs)) {
            return null;
        }
        LinkedCaseInsensitiveMap result = new LinkedCaseInsensitiveMap();
        for (String element : pairs) {
            String[] splittedElement = StringUtils.split((String)element, (String)"=");
            if (splittedElement == null) continue;
            result.put(splittedElement[0].trim(), (Object)splittedElement[1].trim());
        }
        return result;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public HttpHeaders apply(HttpHeaders input, ServerRequest request) {
        if (request.servletRequest().getRemoteAddr() != null && !this.trustedProxies.isTrusted(request.servletRequest().getRemoteAddr())) {
            log.trace((Object)LogMessage.format((String)"Remote address not trusted. pattern %s remote address %s", (Object)this.trustedProxies, (Object)request.servletRequest().getRemoteHost()));
            return input;
        }
        HttpHeaders original = input;
        HttpHeaders updated = new HttpHeaders();
        for (Object entry : original.headerSet()) {
            if (((String)entry.getKey()).equalsIgnoreCase(FORWARDED_HEADER)) continue;
            updated.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        List<Forwarded> forwardeds = ForwardedRequestHeadersFilter.parse(original.get((Object)FORWARDED_HEADER));
        for (Forwarded f : forwardeds) {
            if (!this.trustedProxies.isTrusted(f.get("for"))) continue;
            updated.add(FORWARDED_HEADER, f.toHeaderValue());
        }
        URI uri = request.uri();
        String host = original.getFirst("Host");
        Forwarded forwarded = new Forwarded().put("host", host).put("proto", uri.getScheme());
        request.remoteAddress().ifPresent(remoteAddress -> {
            Object forValue;
            if (remoteAddress.isUnresolved()) {
                forValue = remoteAddress.getHostName();
            } else {
                InetAddress address = remoteAddress.getAddress();
                forValue = remoteAddress.getAddress().getHostAddress();
                if (address instanceof Inet6Address) {
                    forValue = "[" + (String)forValue + "]";
                }
            }
            if (!this.trustedProxies.isTrusted((String)forValue)) {
                return;
            }
            int port = remoteAddress.getPort();
            if (port >= 0 && !((String)forValue).endsWith(":" + port)) {
                forValue = (String)forValue + ":" + port;
            }
            forwarded.put("for", (String)forValue);
        });
        updated.add(FORWARDED_HEADER, forwarded.toHeaderValue());
        return updated;
    }

    static class Forwarded {
        private static final char EQUALS = '=';
        private static final char SEMICOLON = ';';
        private final Map<String, String> values;

        Forwarded() {
            this.values = new HashMap<String, String>();
        }

        Forwarded(Map<String, String> values) {
            this.values = values;
        }

        public Forwarded put(String key, String value) {
            this.values.put(key, this.quoteIfNeeded(value));
            return this;
        }

        private String quoteIfNeeded(String s) {
            if (s != null && s.contains(":")) {
                return "\"" + s + "\"";
            }
            return s;
        }

        public String get(String key) {
            return this.values.get(key);
        }

        Map<String, String> getValues() {
            return this.values;
        }

        public String toString() {
            return "Forwarded{values=" + this.values + "}";
        }

        public String toHeaderValue() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(';');
                }
                builder.append(entry.getKey()).append('=').append(entry.getValue());
            }
            return builder.toString();
        }
    }
}

