/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.common;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class MultipartEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    static final String MULTIPART_ENABLED_PROPERTY = "spring.servlet.multipart.enabled";
    static final String MULTIPART_PROPERTY_SOURCE_NAME = "gatewayServerWebmvcMultipartPropertySource";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String multipartEnabled = environment.getProperty(MULTIPART_ENABLED_PROPERTY);
        if (!StringUtils.hasText((String)multipartEnabled)) {
            MapPropertySource propertySource = new MapPropertySource(MULTIPART_PROPERTY_SOURCE_NAME, Map.of(MULTIPART_ENABLED_PROPERTY, Boolean.FALSE));
            environment.getPropertySources().addFirst((PropertySource)propertySource);
        }
    }
}

