/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc;

import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.client.HttpClientAutoConfiguration;
import org.springframework.boot.autoconfigure.http.client.HttpClientProperties;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.cloud.gateway.server.mvc.common.ArgumentSupplierBeanPostProcessor;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcAotRuntimeHintsRegistrar;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcProperties;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcPropertiesBeanDefinitionRegistrar;
import org.springframework.cloud.gateway.server.mvc.config.RouterFunctionHolderFactory;
import org.springframework.cloud.gateway.server.mvc.filter.FormFilter;
import org.springframework.cloud.gateway.server.mvc.filter.ForwardedRequestHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.RemoveContentLengthRequestHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.RemoveHopByHopRequestHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.RemoveHopByHopResponseHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.RemoveHttp2StatusResponseHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.TransferEncodingNormalizationRequestHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.WeightCalculatorFilter;
import org.springframework.cloud.gateway.server.mvc.filter.XForwardedRequestHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.XForwardedRequestHeadersFilterProperties;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchange;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchangeHandlerFunction;
import org.springframework.cloud.gateway.server.mvc.handler.RestClientProxyExchange;
import org.springframework.cloud.gateway.server.mvc.predicate.PredicateDiscoverer;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={HttpClientAutoConfiguration.class, RestTemplateAutoConfiguration.class, RestClientAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.gateway.mvc.enabled"}, matchIfMissing=true)
@Import(value={GatewayMvcPropertiesBeanDefinitionRegistrar.class})
@ImportRuntimeHints(value={GatewayMvcAotRuntimeHintsRegistrar.class})
public class GatewayServerMvcAutoConfiguration {
    @Bean
    public static ArgumentSupplierBeanPostProcessor argumentSupplierBeanPostProcessor(ApplicationEventPublisher publisher) {
        return new ArgumentSupplierBeanPostProcessor(publisher);
    }

    @Bean
    public RouterFunctionHolderFactory routerFunctionHolderFactory(Environment env) {
        return new RouterFunctionHolderFactory(env);
    }

    @Bean
    public RestClientCustomizer gatewayRestClientCustomizer(ObjectProvider<ClientHttpRequestFactory> requestFactoryProvider) {
        return restClientBuilder -> requestFactoryProvider.ifAvailable(arg_0 -> ((RestClient.Builder)restClientBuilder).requestFactory(arg_0));
    }

    @Bean
    @ConditionalOnMissingBean(value={ProxyExchange.class})
    public RestClientProxyExchange restClientProxyExchange(RestClient.Builder restClientBuilder, GatewayMvcProperties properties) {
        return new RestClientProxyExchange(restClientBuilder.build(), properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc", name={"form-filter.enabled"}, matchIfMissing=true)
    public FormFilter formFilter() {
        return new FormFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc", name={"forwarded-request-headers-filter.enabled"}, matchIfMissing=true)
    public ForwardedRequestHeadersFilter forwardedRequestHeadersFilter() {
        return new ForwardedRequestHeadersFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public GatewayMvcProperties gatewayMvcProperties() {
        return new GatewayMvcProperties();
    }

    @Bean
    public PredicateDiscoverer predicateDiscoverer() {
        return new PredicateDiscoverer();
    }

    @Bean
    @ConditionalOnMissingBean
    public ProxyExchangeHandlerFunction proxyExchangeHandlerFunction(ProxyExchange proxyExchange, ObjectProvider<HttpHeadersFilter.RequestHttpHeadersFilter> requestHttpHeadersFilters, ObjectProvider<HttpHeadersFilter.ResponseHttpHeadersFilter> responseHttpHeadersFilters) {
        return new ProxyExchangeHandlerFunction(proxyExchange, requestHttpHeadersFilters, responseHttpHeadersFilters);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc", name={"remove-content-length-request-headers-filter.enabled"}, matchIfMissing=true)
    public RemoveContentLengthRequestHeadersFilter removeContentLengthRequestHeadersFilter() {
        return new RemoveContentLengthRequestHeadersFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc", name={"remove-http2-status-response-headers-filter.enabled"}, matchIfMissing=true)
    public RemoveHttp2StatusResponseHeadersFilter removeHttp2StatusResponseHeadersFilter() {
        return new RemoveHttp2StatusResponseHeadersFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc", name={"remove-hop-by-hop-request-headers-filter.enabled"}, matchIfMissing=true)
    public RemoveHopByHopRequestHeadersFilter removeHopByHopRequestHeadersFilter() {
        return new RemoveHopByHopRequestHeadersFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc", name={"remove-hop-by-hop-response-headers-filter.enabled"}, matchIfMissing=true)
    public RemoveHopByHopResponseHeadersFilter removeHopByHopResponseHeadersFilter() {
        return new RemoveHopByHopResponseHeadersFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc", name={"transfer-encoding-normalization-request-headers-filter.enabled"}, matchIfMissing=true)
    public TransferEncodingNormalizationRequestHeadersFilter transferEncodingNormalizationRequestHeadersFilter() {
        return new TransferEncodingNormalizationRequestHeadersFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc", name={"weight-calculator-filter.enabled"}, matchIfMissing=true)
    public WeightCalculatorFilter weightCalculatorFilter() {
        return new WeightCalculatorFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter", name={".enabled"}, matchIfMissing=true)
    public XForwardedRequestHeadersFilter xForwardedRequestHeadersFilter(XForwardedRequestHeadersFilterProperties props) {
        return new XForwardedRequestHeadersFilter(props);
    }

    @Bean
    public XForwardedRequestHeadersFilterProperties xForwardedRequestHeadersFilterProperties() {
        return new XForwardedRequestHeadersFilterProperties();
    }

    static class GatewayHttpClientEnvironmentPostProcessor
    implements EnvironmentPostProcessor {
        static final boolean APACHE = ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.classic.HttpClients", null);
        static final boolean JETTY = ClassUtils.isPresent((String)"org.eclipse.jetty.client.HttpClient", null);
        static final boolean REACTOR_NETTY = ClassUtils.isPresent((String)"reactor.netty.http.client.HttpClient", null);
        static final boolean JDK = ClassUtils.isPresent((String)"java.net.http.HttpClient", null);
        static final boolean HIGHER_PRIORITY = APACHE || JETTY || REACTOR_NETTY;

        GatewayHttpClientEnvironmentPostProcessor() {
        }

        public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
            ClientHttpRequestFactorySettings.Redirects redirects = (ClientHttpRequestFactorySettings.Redirects)environment.getProperty("spring.http.client.redirects", ClientHttpRequestFactorySettings.Redirects.class);
            if (redirects == null) {
                environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("gatewayHttpClientProperties", Map.of("spring.http.client.redirects", ClientHttpRequestFactorySettings.Redirects.DONT_FOLLOW)));
            }
            HttpClientProperties.Factory factory = (HttpClientProperties.Factory)environment.getProperty("spring.http.client.factory", HttpClientProperties.Factory.class);
            boolean setJdkHttpClientProperties = false;
            if (factory == null && !HIGHER_PRIORITY) {
                setJdkHttpClientProperties = JDK;
            } else if (factory == HttpClientProperties.Factory.JDK) {
                setJdkHttpClientProperties = JDK;
            }
            if (setJdkHttpClientProperties) {
                String restrictedHeaders = System.getProperty("jdk.httpclient.allowRestrictedHeaders");
                if (!StringUtils.hasText((String)restrictedHeaders)) {
                    System.setProperty("jdk.httpclient.allowRestrictedHeaders", "host");
                } else if (StringUtils.hasText((String)restrictedHeaders) && !restrictedHeaders.contains("host")) {
                    System.setProperty("jdk.httpclient.allowRestrictedHeaders", restrictedHeaders + ",host");
                }
            }
        }
    }
}

