/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.sample;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.isomorphism.util.TokenBucket;
import org.isomorphism.util.TokenBuckets;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ThrottleGatewayFilter
implements GatewayFilter {
    private static final Log log = LogFactory.getLog(ThrottleGatewayFilter.class);
    private volatile TokenBucket tokenBucket;
    int capacity;
    int refillTokens;
    int refillPeriod;
    TimeUnit refillUnit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenBucket getTokenBucket() {
        if (this.tokenBucket != null) {
            return this.tokenBucket;
        }
        ThrottleGatewayFilter throttleGatewayFilter = this;
        synchronized (throttleGatewayFilter) {
            if (this.tokenBucket == null) {
                this.tokenBucket = TokenBuckets.builder().withCapacity((long)this.capacity).withFixedIntervalRefillStrategy((long)this.refillTokens, (long)this.refillPeriod, this.refillUnit).build();
            }
        }
        return this.tokenBucket;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ThrottleGatewayFilter setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public int getRefillTokens() {
        return this.refillTokens;
    }

    public ThrottleGatewayFilter setRefillTokens(int refillTokens) {
        this.refillTokens = refillTokens;
        return this;
    }

    public int getRefillPeriod() {
        return this.refillPeriod;
    }

    public ThrottleGatewayFilter setRefillPeriod(int refillPeriod) {
        this.refillPeriod = refillPeriod;
        return this;
    }

    public TimeUnit getRefillUnit() {
        return this.refillUnit;
    }

    public ThrottleGatewayFilter setRefillUnit(TimeUnit refillUnit) {
        this.refillUnit = refillUnit;
        return this;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        TokenBucket tokenBucket = this.getTokenBucket();
        log.debug((Object)("TokenBucket capacity: " + tokenBucket.getCapacity()));
        boolean consumed = tokenBucket.tryConsume();
        if (consumed) {
            return chain.filter(exchange);
        }
        exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS);
        return exchange.getResponse().setComplete();
    }
}

