/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;

class ServletOutputToInputConverter
extends HttpServletResponseWrapper {
    private StringBuilder builder = new StringBuilder();

    ServletOutputToInputConverter(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                ServletOutputToInputConverter.this.builder.append(Character.valueOf((char)b));
            }

            public void setWriteListener(WriteListener listener) {
            }

            public boolean isReady() {
                return true;
            }
        };
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream body = new ByteArrayInputStream(this.builder.toString().getBytes());
        return new ServletInputStream(){

            public int read() throws IOException {
                return body.read();
            }

            public void setReadListener(ReadListener listener) {
            }

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                return body.available() <= 0;
            }
        };
    }
}

