/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc;

import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.Function;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.gateway.mvc.ServletOutputToInputConverter;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class ProxyExchange<T> {
    public static Set<String> DEFAULT_SENSITIVE = new HashSet<String>(Arrays.asList("cookie", "authorization"));
    private URI uri;
    private RestTemplate rest;
    private Object body;
    private RequestResponseBodyMethodProcessor delegate;
    private NativeWebRequest webRequest;
    private ModelAndViewContainer mavContainer;
    private WebDataBinderFactory binderFactory;
    private Set<String> sensitive;
    private HttpHeaders headers = new HttpHeaders();
    private Type responseType;

    public ProxyExchange(RestTemplate rest, NativeWebRequest webRequest, ModelAndViewContainer mavContainer, WebDataBinderFactory binderFactory, Type type) {
        this.responseType = type;
        this.rest = rest;
        this.webRequest = webRequest;
        this.mavContainer = mavContainer;
        this.binderFactory = binderFactory;
        this.delegate = new RequestResponseBodyMethodProcessor(rest.getMessageConverters());
    }

    public ProxyExchange<T> body(Object body) {
        this.body = body;
        return this;
    }

    public ProxyExchange<T> header(String name, String ... value) {
        this.headers.put(name, Arrays.asList(value));
        return this;
    }

    public ProxyExchange<T> headers(HttpHeaders headers) {
        this.headers.putAll((Map)headers);
        return this;
    }

    public ProxyExchange<T> sensitive(String ... names) {
        if (this.sensitive == null) {
            this.sensitive = new HashSet<String>();
        }
        for (String name : names) {
            this.sensitive.add(name.toLowerCase());
        }
        return this;
    }

    public ProxyExchange<T> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ProxyExchange<T> uri(String uri) {
        try {
            return this.uri(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot create URI", e);
        }
    }

    public String path() {
        return (String)this.webRequest.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, 0);
    }

    public String path(String prefix) {
        String path = this.path();
        if (!path.startsWith(prefix)) {
            throw new IllegalArgumentException("Path does not start with prefix (" + prefix + "): " + path);
        }
        return path.substring(prefix.length());
    }

    public void forward(String path) {
        HttpServletRequest request = (HttpServletRequest)this.webRequest.getNativeRequest(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)this.webRequest.getNativeResponse(HttpServletResponse.class);
        try {
            request.getRequestDispatcher(path).forward((ServletRequest)new BodyForwardingHttpServletRequest(request, response), (ServletResponse)response);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot forward request", e);
        }
    }

    public ResponseEntity<T> get() {
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.get((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> get(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.get());
    }

    public ResponseEntity<T> head() {
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.head((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> head(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.head());
    }

    public ResponseEntity<T> options() {
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.options((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> options(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.options());
    }

    public ResponseEntity<T> post() {
        RequestEntity requestEntity = this.headers(RequestEntity.post((URI)this.uri)).body(this.body());
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> post(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.post());
    }

    public ResponseEntity<T> delete() {
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.delete((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> delete(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.delete());
    }

    public ResponseEntity<T> put() {
        RequestEntity requestEntity = this.headers(RequestEntity.put((URI)this.uri)).body(this.body());
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> put(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.put());
    }

    public ResponseEntity<T> patch() {
        RequestEntity requestEntity = this.headers(RequestEntity.patch((URI)this.uri)).body(this.body());
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> patch(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.patch());
    }

    private ResponseEntity<T> exchange(RequestEntity<?> requestEntity) {
        Object type = this.responseType;
        if (type instanceof TypeVariable || type instanceof WildcardType) {
            type = Object.class;
        }
        return this.rest.exchange(requestEntity, ParameterizedTypeReference.forType((Type)this.responseType));
    }

    private RequestEntity.BodyBuilder headers(RequestEntity.BodyBuilder builder) {
        Set<String> sensitive = this.sensitive;
        if (sensitive == null) {
            sensitive = DEFAULT_SENSITIVE;
        }
        this.proxy();
        for (String name : this.headers.keySet()) {
            if (sensitive.contains(name.toLowerCase())) continue;
            builder.header(name, this.headers.get((Object)name).toArray(new String[0]));
        }
        return builder;
    }

    private void proxy() {
        try {
            URI uri = new URI(((HttpServletRequest)this.webRequest.getNativeRequest(HttpServletRequest.class)).getRequestURL().toString());
            this.appendForwarded(uri);
            this.appendXForwarded(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot create URI for request: " + ((HttpServletRequest)this.webRequest.getNativeRequest(HttpServletRequest.class)).getRequestURL());
        }
    }

    private void appendXForwarded(URI uri) {
        String host = this.headers.getFirst("x-forwarded-host");
        if (host == null) {
            return;
        }
        host = host + "," + uri.getHost();
        this.headers.set("x-forwarded-host", host);
        String proto = this.headers.getFirst("x-forwarded-proto");
        if (proto == null) {
            return;
        }
        proto = proto + "," + uri.getScheme();
        this.headers.set("x-forwarded-proto", proto);
    }

    private void appendForwarded(URI uri) {
        String forwarded = this.headers.getFirst("forwarded");
        forwarded = forwarded != null ? forwarded + "," : "";
        forwarded = forwarded + this.forwarded(uri, this.webRequest.getHeader("host"));
        this.headers.set("forwarded", forwarded);
    }

    private String forwarded(URI uri, String hostHeader) {
        if (!StringUtils.isEmpty((Object)hostHeader)) {
            return "host=" + hostHeader;
        }
        if ("http".equals(uri.getScheme())) {
            return "host=" + uri.getHost();
        }
        return String.format("host=%s;proto=%s", uri.getHost(), uri.getScheme());
    }

    private Object body() {
        if (this.body != null) {
            return this.body;
        }
        this.body = this.getRequestBody();
        return this.body;
    }

    private Object getRequestBody() {
        for (String key : this.mavContainer.getModel().keySet()) {
            if (!key.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
            BindingResult result = (BindingResult)this.mavContainer.getModel().get((Object)key);
            return result.getTarget();
        }
        MethodParameter input = new MethodParameter(ClassUtils.getMethod(BodyGrabber.class, (String)"body", (Class[])new Class[]{Object.class}), 0);
        try {
            this.delegate.resolveArgument(input, this.mavContainer, this.webRequest, this.binderFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot resolve body", e);
        }
        String name = Conventions.getVariableNameForParameter((MethodParameter)input);
        BindingResult result = (BindingResult)this.mavContainer.getModel().get((Object)(BindingResult.MODEL_KEY_PREFIX + name));
        return result.getTarget();
    }

    class BodyForwardingHttpServletRequest
    extends HttpServletRequestWrapper {
        private HttpServletRequest request;
        private HttpServletResponse response;

        BodyForwardingHttpServletRequest(HttpServletRequest request, HttpServletResponse response) {
            super(request);
            this.request = request;
            this.response = response;
        }

        private List<String> header(String name) {
            List list = ProxyExchange.this.headers.get((Object)name);
            return list;
        }

        public ServletInputStream getInputStream() throws IOException {
            Object body = ProxyExchange.this.body();
            MethodParameter output = new MethodParameter(ClassUtils.getMethod(BodySender.class, (String)"body", (Class[])new Class[0]), -1);
            ServletOutputToInputConverter response = new ServletOutputToInputConverter(this.response);
            ServletWebRequest webRequest = new ServletWebRequest(this.request, (HttpServletResponse)response);
            try {
                ProxyExchange.this.delegate.handleReturnValue(body, output, ProxyExchange.this.mavContainer, (NativeWebRequest)webRequest);
            }
            catch (HttpMessageNotWritableException | HttpMediaTypeNotAcceptableException e) {
                throw new IllegalStateException("Cannot convert body", e);
            }
            return response.getInputStream();
        }

        public Enumeration<String> getHeaderNames() {
            Set names = ProxyExchange.this.headers.keySet();
            if (names.isEmpty()) {
                return super.getHeaderNames();
            }
            LinkedHashSet result = new LinkedHashSet(names);
            result.addAll(Collections.list(super.getHeaderNames()));
            return new Vector(result).elements();
        }

        public Enumeration<String> getHeaders(String name) {
            List<String> list = this.header(name);
            if (list != null) {
                return new Vector<String>(list).elements();
            }
            return super.getHeaders(name);
        }

        public String getHeader(String name) {
            List<String> list = this.header(name);
            if (list != null && !list.isEmpty()) {
                return list.iterator().next();
            }
            return super.getHeader(name);
        }
    }

    protected static class BodySender {
        protected BodySender() {
        }

        @ResponseBody
        public Object body() {
            return null;
        }
    }

    protected static class BodyGrabber {
        protected BodyGrabber() {
        }

        public Object body(@RequestBody(required=false) Object body) {
            return body;
        }
    }
}

