/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.FunctionHttpProperties;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.util.FunctionWrapper;
import org.springframework.cloud.function.web.util.HeaderUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FunctionWebRequestProcessingHelper {
    private static Log logger = LogFactory.getLog(FunctionWebRequestProcessingHelper.class);

    private FunctionWebRequestProcessingHelper() {
    }

    public static SimpleFunctionRegistry.FunctionInvocationWrapper findFunction(FunctionProperties functionProperties, HttpMethod method, FunctionCatalog functionCatalog, Map<String, Object> attributes, String path) {
        if (method.equals((Object)HttpMethod.GET) || method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT) || method.equals((Object)HttpMethod.DELETE)) {
            return FunctionWebRequestProcessingHelper.doFindFunction(functionProperties.getDefinition(), method, functionCatalog, attributes, path);
        }
        throw new IllegalStateException("HTTP method '" + method + "' is not supported;");
    }

    public static Object invokeFunction(SimpleFunctionRegistry.FunctionInvocationWrapper function, Object input, boolean isMessage) {
        Object result = function.apply(input);
        return FunctionWebRequestProcessingHelper.postProcessResult(result, isMessage);
    }

    public static boolean isFunctionValidForMethod(String httpMethod, String functionDefinition, FunctionHttpProperties functionHttpProperties) {
        String functionDefinitions = null;
        switch (httpMethod) {
            case "GET": {
                functionDefinitions = functionHttpProperties.getGet();
                break;
            }
            case "POST": {
                functionDefinitions = functionHttpProperties.getPost();
                break;
            }
            case "PUT": {
                functionDefinitions = functionHttpProperties.getPut();
                break;
            }
            case "DELETE": {
                functionDefinitions = functionHttpProperties.getDelete();
                break;
            }
            default: {
                return false;
            }
        }
        if (StringUtils.hasText((String)functionDefinitions)) {
            return Arrays.asList(functionDefinitions.split(";")).contains(functionDefinition);
        }
        return true;
    }

    public static String buildBadMappingErrorMessage(String httpMethod, String functionDefinition) {
        return "Function '" + functionDefinition + "' is not eligible to be invoked via  " + httpMethod + "  method. This is due to the fact that explicit mappings for " + httpMethod + " are provided via 'spring.cloud.function.http." + httpMethod + "' property and this function is not listed there. Either remove all explicit mappings for " + httpMethod + " or add this function to the list of functions specified in 'spring.cloud.function.http." + httpMethod + "' property.";
    }

    public static Publisher<?> processRequest(FunctionWrapper wrapper, Object argument, boolean eventStream, List<String> ignoredHeaders, List<String> requestOnlyHeaders) {
        Publisher pResult;
        SimpleFunctionRegistry.FunctionInvocationWrapper function;
        if (argument == null) {
            argument = "";
        }
        if ((function = wrapper.getFunction()) == null) {
            return Mono.just((Object)ResponseEntity.notFound().build());
        }
        HttpHeaders headers = wrapper.getHeaders();
        Message inputMessage = null;
        MessageBuilder builder = MessageBuilder.withPayload((Object)argument);
        if (!CollectionUtils.isEmpty(wrapper.getParams())) {
            builder = builder.setHeader("http_request_param", (Object)wrapper.getParams().toSingleValueMap());
        }
        inputMessage = builder.copyHeaders(headers.toSingleValueMap()).build();
        if (function.isRoutingFunction()) {
            function.setSkipOutputConversion(true);
        }
        Object result = function.apply((Object)inputMessage);
        if (function.isConsumer()) {
            if (result instanceof Publisher) {
                Mono.from((Publisher)((Publisher)result)).subscribe();
            }
            return "DELETE".equals(wrapper.getMethod()) ? Mono.empty() : Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.accepted().headers(HeaderUtils.sanitize(headers, ignoredHeaders, requestOnlyHeaders))).build());
        }
        ResponseEntity.BodyBuilder responseOkBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtils.sanitize(headers, ignoredHeaders, requestOnlyHeaders));
        if (result instanceof Publisher) {
            pResult = (Publisher)result;
            if (eventStream) {
                return Flux.from((Publisher)pResult);
            }
            if (pResult instanceof Flux) {
                pResult = ((Flux)pResult).onErrorContinue((e, v) -> logger.error((Object)("Failed to process value: " + v), (Throwable)e)).collectList();
            }
            pResult = Mono.from((Publisher)pResult);
        } else {
            pResult = Mono.just((Object)result);
        }
        return Mono.from((Publisher)pResult).map(v -> {
            if (v instanceof Iterable) {
                Iterable i = (Iterable)v;
                List aggregatedResult = StreamSupport.stream(i.spliterator(), false).map(m -> m instanceof Message ? FunctionWebRequestProcessingHelper.processMessage(responseOkBuilder, (Message)m, ignoredHeaders) : m).collect(Collectors.toList());
                return ((ResponseEntity.BodyBuilder)responseOkBuilder.header("content-type", new String[]{"application/json"})).body(aggregatedResult);
            }
            if (v instanceof Message) {
                return responseOkBuilder.body(FunctionWebRequestProcessingHelper.processMessage(responseOkBuilder, (Message)v, ignoredHeaders));
            }
            return responseOkBuilder.body(v);
        });
    }

    private static Object processMessage(ResponseEntity.BodyBuilder responseOkBuilder, Message<?> message, List<String> ignoredHeaders) {
        responseOkBuilder.headers(HeaderUtils.fromMessage(message.getHeaders(), ignoredHeaders));
        return message.getPayload();
    }

    private static SimpleFunctionRegistry.FunctionInvocationWrapper doFindFunction(String functionDefinition, HttpMethod method, FunctionCatalog functionCatalog, Map<String, Object> attributes, String path) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function;
        SimpleFunctionRegistry.FunctionInvocationWrapper function2;
        String string = path = path.startsWith("/") ? path.substring(1) : path;
        if (method.equals((Object)HttpMethod.GET) && (function2 = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(path)) != null && function2.isSupplier()) {
            attributes.put(WebRequestConstants.SUPPLIER, function2);
            return function2;
        }
        StringBuilder builder = new StringBuilder();
        String name = path;
        String value = null;
        for (String element : path.split("/")) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(element);
            name = builder.toString();
            value = path.length() > name.length() ? path.substring(name.length() + 1) : null;
            SimpleFunctionRegistry.FunctionInvocationWrapper function3 = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(name);
            if (function3 == null) continue;
            return FunctionWebRequestProcessingHelper.postProcessFunction(function3, value, attributes);
        }
        if (StringUtils.hasText((String)functionDefinition) && (function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionDefinition)) != null) {
            return FunctionWebRequestProcessingHelper.postProcessFunction(function, value, attributes);
        }
        return null;
    }

    private static SimpleFunctionRegistry.FunctionInvocationWrapper postProcessFunction(SimpleFunctionRegistry.FunctionInvocationWrapper function, String argument, Map<String, Object> attributes) {
        attributes.put(WebRequestConstants.FUNCTION, function);
        if (argument != null) {
            attributes.put(WebRequestConstants.ARGUMENT, argument);
        }
        return function;
    }

    private static Object postProcessResult(Object result, boolean isMessage) {
        if (result instanceof Flux) {
            result = ((Flux)result).map(v -> FunctionWebRequestProcessingHelper.postProcessResult(v, isMessage));
        } else if (result instanceof Mono) {
            result = ((Mono)result).map(v -> FunctionWebRequestProcessingHelper.postProcessResult(v, isMessage));
        } else if (result instanceof Message) {
            Message messageResult = (Message)result;
            if (messageResult.getPayload() instanceof byte[]) {
                result = MessageBuilder.withPayload((Object)messageResult.getPayload()).copyHeaders((Map)((Message)result).getHeaders()).build();
            }
        } else if (result instanceof byte[]) {
            result = new String((byte[])result, StandardCharsets.UTF_8);
        }
        return result;
    }
}

