/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.function;

import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.FunctionHttpProperties;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.util.FunctionWebRequestProcessingHelper;
import org.springframework.cloud.function.web.util.FunctionWrapper;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class FunctionEndpointFactory {
    private static Log logger = LogFactory.getLog(FunctionEndpointFactory.class);
    private final FunctionCatalog functionCatalog;
    private final String handler;
    private final FunctionProperties functionProperties;
    private final FunctionHttpProperties functionHttpProperties;

    FunctionEndpointFactory(FunctionProperties functionProperties, FunctionCatalog functionCatalog, Environment environment, FunctionHttpProperties functionHttpProperties) {
        String handler = environment.resolvePlaceholders("${function.handler}");
        if (handler.startsWith("$")) {
            handler = null;
        }
        this.functionCatalog = functionCatalog;
        this.handler = handler;
        this.functionProperties = functionProperties;
        this.functionHttpProperties = functionHttpProperties;
    }

    private SimpleFunctionRegistry.FunctionInvocationWrapper extract(ServerRequest request) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function;
        if (this.handler != null) {
            logger.info((Object)("Configured function: " + this.handler));
            Set names = this.functionCatalog.getNames(Function.class);
            Assert.isTrue((boolean)names.contains(this.handler), (String)("Cannot locate function: " + this.handler));
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.functionCatalog.lookup(Function.class, this.handler);
        } else {
            function = FunctionWebRequestProcessingHelper.findFunction(this.functionProperties, request.method(), this.functionCatalog, request.attributes(), request.path());
        }
        return function;
    }

    public <T> RouterFunction<?> functionEndpoints() {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.POST((String)"/**"), request -> {
            SimpleFunctionRegistry.FunctionInvocationWrapper funcWrapper = this.extract(request);
            Class outputType = funcWrapper == null ? Object.class : FunctionTypeUtils.getRawType((Type)FunctionTypeUtils.getGenericType((Type)funcWrapper.getOutputType()));
            FunctionWrapper wrapper = new FunctionWrapper(funcWrapper, null);
            Mono stream = request.bodyToMono(String.class).flatMap(content -> (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, content, false, this.functionHttpProperties.getIgnoredHeaders(), this.functionHttpProperties.getRequestOnlyHeaders()));
            return stream.flatMap(entity -> {
                ServerResponse.BodyBuilder builder = (ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)entity.getStatusCode()).headers(headers -> headers.addAll(entity.getHeaders()));
                if (outputType == null) {
                    return builder.build();
                }
                return builder.body((Object)(entity != null && entity.hasBody() ? Mono.just((Object)entity.getBody()) : Mono.empty()), outputType);
            });
        }).andRoute(RequestPredicates.GET((String)"/**"), request -> {
            SimpleFunctionRegistry.FunctionInvocationWrapper funcWrapper = this.extract(request);
            Class outputType = FunctionTypeUtils.getRawType((Type)FunctionTypeUtils.getGenericType((Type)funcWrapper.getOutputType()));
            if (funcWrapper.isSupplier()) {
                Object result = FunctionWebRequestProcessingHelper.invokeFunction(funcWrapper, null, funcWrapper.isInputTypeMessage());
                if (!(result instanceof Publisher)) {
                    result = Mono.just((Object)result);
                }
                return ServerResponse.ok().body(result, outputType);
            }
            FunctionWrapper wrapper = new FunctionWrapper(funcWrapper, null);
            wrapper.setHeaders(request.headers().asHttpHeaders());
            String argument = (String)request.attribute(WebRequestConstants.ARGUMENT).get();
            wrapper.setArgument(Flux.just((Object)argument));
            Object result = FunctionWebRequestProcessingHelper.invokeFunction(funcWrapper, wrapper.getArgument(), funcWrapper.isInputTypeMessage());
            return ServerResponse.ok().body(result, outputType);
        });
    }
}

